/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.commands;

import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;

public class CommandSerialNumberCache {
    private static final int DEFAULT_MAX_CAPACITY = 64;
    private final Deque<String> queue;
    private final int maxCapacity;

    public CommandSerialNumberCache() {
        this(64);
    }

    public CommandSerialNumberCache(int maxCapacity) {
        this.queue = new LinkedBlockingDeque<String>(maxCapacity);
        this.maxCapacity = maxCapacity;
    }

    public void add(String number) {
        if (this.queue.size() >= this.maxCapacity) {
            this.queue.pollFirst();
        }
        this.queue.add(number);
    }

    public boolean contain(String command) {
        return this.queue.contains(command);
    }
}

