/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.trace.ignore.matcher;

import org.apache.skywalking.apm.plugin.trace.ignore.matcher.TracePathMatcher;

public class FastPathMatcher
implements TracePathMatcher {
    @Override
    public boolean match(String pattern, String path) {
        return this.normalMatch(pattern, 0, path, 0);
    }

    private boolean normalMatch(String pat, int p, String str, int s) {
        while (p < pat.length()) {
            char pc = pat.charAt(p);
            char sc = this.safeCharAt(str, s);
            if (pc == '*') {
                if (this.safeCharAt(pat, ++p) == '*') {
                    return this.multiWildcardMatch(pat, ++p, str, s);
                }
                return this.wildcardMatch(pat, p, str, s);
            }
            if (pc == '?' && sc != '\u0000' && sc != '/' || pc == sc) {
                ++s;
                ++p;
                continue;
            }
            return false;
        }
        return s == str.length();
    }

    private boolean wildcardMatch(String pat, int p, String str, int s) {
        char pc = this.safeCharAt(pat, p);
        while (true) {
            char sc;
            if ((sc = this.safeCharAt(str, s)) == '/') {
                if (pc == sc) {
                    return this.normalMatch(pat, p + 1, str, s + 1);
                }
                return false;
            }
            if (this.normalMatch(pat, p, str, s)) break;
            if (s >= str.length()) {
                return false;
            }
            ++s;
        }
        return true;
    }

    private boolean multiWildcardMatch(String pat, int p, String str, int s) {
        if (p >= pat.length() && s < str.length()) {
            return str.charAt(str.length() - 1) != '/';
        }
        while (!this.normalMatch(pat, p, str, s)) {
            if (s >= str.length()) {
                return false;
            }
            ++s;
        }
        return true;
    }

    private char safeCharAt(String value, int index) {
        if (index >= value.length()) {
            return '\u0000';
        }
        return value.charAt(index);
    }
}

