/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.logging.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.core.Converter;
import org.apache.skywalking.apm.agent.core.logging.core.LogLevel;
import org.apache.skywalking.apm.agent.core.logging.core.WriterFactory;
import org.apache.skywalking.apm.agent.core.logging.core.converters.AgentNameConverter;
import org.apache.skywalking.apm.agent.core.logging.core.converters.ClassConverter;
import org.apache.skywalking.apm.agent.core.logging.core.converters.DateConverter;
import org.apache.skywalking.apm.agent.core.logging.core.converters.LevelConverter;
import org.apache.skywalking.apm.agent.core.logging.core.converters.MessageConverter;
import org.apache.skywalking.apm.agent.core.logging.core.converters.ThreadConverter;
import org.apache.skywalking.apm.agent.core.logging.core.converters.ThrowableConverter;

public abstract class AbstractLogger
implements ILog {
    public static final Map<String, Class<? extends Converter>> DEFAULT_CONVERTER_MAP = new HashMap<String, Class<? extends Converter>>();
    protected List<Converter> converters = new ArrayList<Converter>();
    protected final String targetClass;

    public AbstractLogger(String targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public void info(String message) {
        if (this.isInfoEnable()) {
            this.logger(LogLevel.INFO, message, null);
        }
    }

    @Override
    public void info(String message, Object ... objects) {
        if (this.isInfoEnable()) {
            this.logger(LogLevel.INFO, this.replaceParam(message, objects), null);
        }
    }

    @Override
    public void info(Throwable throwable, String message, Object ... objects) {
        if (this.isInfoEnable()) {
            this.logger(LogLevel.INFO, this.replaceParam(message, objects), throwable);
        }
    }

    @Override
    public void warn(String message, Object ... objects) {
        if (this.isWarnEnable()) {
            this.logger(LogLevel.WARN, this.replaceParam(message, objects), null);
        }
    }

    @Override
    public void warn(Throwable throwable, String message, Object ... objects) {
        if (this.isWarnEnable()) {
            this.logger(LogLevel.WARN, this.replaceParam(message, objects), throwable);
        }
    }

    @Override
    public void error(String message, Throwable throwable) {
        if (this.isErrorEnable()) {
            this.logger(LogLevel.ERROR, message, throwable);
        }
    }

    @Override
    public void error(Throwable throwable, String message, Object ... objects) {
        if (this.isErrorEnable()) {
            this.logger(LogLevel.ERROR, this.replaceParam(message, objects), throwable);
        }
    }

    @Override
    public void error(String message) {
        if (this.isErrorEnable()) {
            this.logger(LogLevel.ERROR, message, null);
        }
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnable()) {
            this.logger(LogLevel.DEBUG, message, null);
        }
    }

    @Override
    public void debug(String message, Object ... objects) {
        if (this.isDebugEnable()) {
            this.logger(LogLevel.DEBUG, this.replaceParam(message, objects), null);
        }
    }

    @Override
    public void debug(Throwable throwable, String message, Object ... objects) {
        if (this.isDebugEnable()) {
            this.logger(LogLevel.DEBUG, this.replaceParam(message, objects), throwable);
        }
    }

    @Override
    public boolean isDebugEnable() {
        return LogLevel.DEBUG.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public boolean isInfoEnable() {
        return LogLevel.INFO.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public boolean isWarnEnable() {
        return LogLevel.WARN.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public boolean isErrorEnable() {
        return LogLevel.ERROR.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public boolean isTraceEnabled() {
        return LogLevel.TRACE.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.logger(LogLevel.TRACE, message, null);
        }
    }

    @Override
    public void trace(String message, Object ... objects) {
        if (this.isTraceEnabled()) {
            this.logger(LogLevel.TRACE, this.replaceParam(message, objects), null);
        }
    }

    @Override
    public void trace(Throwable throwable, String message, Object ... objects) {
        if (this.isTraceEnabled()) {
            this.logger(LogLevel.TRACE, this.replaceParam(message, objects), throwable);
        }
    }

    protected String replaceParam(String message, Object ... parameters) {
        int index;
        if (message == null) {
            return message;
        }
        int startSize = 0;
        int parametersIndex = 0;
        String tmpMessage = message;
        while ((index = message.indexOf("{}", startSize)) != -1 && parametersIndex < parameters.length) {
            tmpMessage = tmpMessage.replaceFirst("\\{\\}", Matcher.quoteReplacement(String.valueOf(parameters[parametersIndex++])));
            startSize = index + 2;
        }
        return tmpMessage;
    }

    protected void logger(LogLevel level, String message, Throwable e) {
        WriterFactory.getLogWriter().write(this.format(level, message, e));
    }

    protected abstract String format(LogLevel var1, String var2, Throwable var3);

    static {
        DEFAULT_CONVERTER_MAP.put("thread", ThreadConverter.class);
        DEFAULT_CONVERTER_MAP.put("level", LevelConverter.class);
        DEFAULT_CONVERTER_MAP.put("agent_name", AgentNameConverter.class);
        DEFAULT_CONVERTER_MAP.put("timestamp", DateConverter.class);
        DEFAULT_CONVERTER_MAP.put("msg", MessageConverter.class);
        DEFAULT_CONVERTER_MAP.put("throwable", ThrowableConverter.class);
        DEFAULT_CONVERTER_MAP.put("class", ClassConverter.class);
    }
}

