/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.profile;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.profile.ProfileTaskChannelService;
import org.apache.skywalking.apm.agent.core.profile.ProfileTaskExecutionContext;
import org.apache.skywalking.apm.agent.core.profile.ProfileTaskExecutionService;
import org.apache.skywalking.apm.agent.core.profile.ThreadProfiler;
import org.apache.skywalking.apm.agent.core.profile.TracingThreadSnapshot;

public class ProfileThread
implements Runnable {
    private static final ILog LOGGER = LogManager.getLogger(ProfileThread.class);
    private final ProfileTaskExecutionContext taskExecutionContext;
    private final ProfileTaskExecutionService profileTaskExecutionService;
    private final ProfileTaskChannelService profileTaskChannelService;

    public ProfileThread(ProfileTaskExecutionContext taskExecutionContext) {
        this.taskExecutionContext = taskExecutionContext;
        this.profileTaskExecutionService = ServiceManager.INSTANCE.findService(ProfileTaskExecutionService.class);
        this.profileTaskChannelService = ServiceManager.INSTANCE.findService(ProfileTaskChannelService.class);
    }

    @Override
    public void run() {
        try {
            this.profiling(this.taskExecutionContext);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            LOGGER.error(e, "Profiling task fail. taskId:{}", this.taskExecutionContext.getTask().getTaskId());
        }
        finally {
            this.profileTaskExecutionService.stopCurrentProfileTask(this.taskExecutionContext);
        }
    }

    private void profiling(ProfileTaskExecutionContext executionContext) throws InterruptedException {
        int maxSleepPeriod = executionContext.getTask().getThreadDumpPeriod();
        long currentLoopStartTime = -1L;
        while (!Thread.currentThread().isInterrupted()) {
            currentLoopStartTime = System.currentTimeMillis();
            AtomicReferenceArray<ThreadProfiler> profilers = executionContext.threadProfilerSlots();
            int profilerCount = profilers.length();
            block5: for (int slot = 0; slot < profilerCount; ++slot) {
                ThreadProfiler currentProfiler = profilers.get(slot);
                if (currentProfiler == null) continue;
                switch (currentProfiler.profilingStatus().get()) {
                    case PENDING: {
                        currentProfiler.startProfilingIfNeed();
                        continue block5;
                    }
                    case PROFILING: {
                        TracingThreadSnapshot snapshot = currentProfiler.buildSnapshot();
                        if (snapshot != null) {
                            this.profileTaskChannelService.addProfilingSnapshot(snapshot);
                            continue block5;
                        }
                        executionContext.stopTracingProfile(currentProfiler.tracingContext());
                    }
                }
            }
            long needToSleep = currentLoopStartTime + (long)maxSleepPeriod - System.currentTimeMillis();
            needToSleep = needToSleep > 0L ? needToSleep : (long)maxSleepPeriod;
            Thread.sleep(needToSleep);
        }
    }
}

