/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v6.interceptor;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.TransportAddressCache;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.TransportClientEnhanceInfo;
import org.elasticsearch.action.support.AdapterActionFuture;
import org.elasticsearch.common.transport.TransportAddress;

public class TransportClientNodesServiceInterceptor
implements InstanceConstructorInterceptor {
    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        EnhancedInstance actions = (EnhancedInstance)allArguments[1];
        objInst.setSkyWalkingDynamicField(actions.getSkyWalkingDynamicField());
    }

    public static class ExecuteInterceptor
    implements InstanceMethodsAroundInterceptor {
        public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
            if (allArguments.length >= 2 && allArguments[1] instanceof AdapterActionFuture) {
                AdapterActionFuture actionFuture = (AdapterActionFuture)allArguments[1];
                ((EnhancedInstance)actionFuture).setSkyWalkingDynamicField((Object)true);
            }
        }

        public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
            return null;
        }

        public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        }
    }

    public static class RemoveTransportAddressInterceptor
    implements InstanceMethodsAroundInterceptor {
        public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        }

        public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
            TransportClientEnhanceInfo transportClientEnhanceInfo = (TransportClientEnhanceInfo)objInst.getSkyWalkingDynamicField();
            TransportAddressCache transportAddressCache = transportClientEnhanceInfo.getTransportAddressCache();
            if (transportAddressCache == null) {
                transportAddressCache = new TransportAddressCache();
                transportClientEnhanceInfo.setTransportAddressCache(transportAddressCache);
            }
            transportAddressCache.removeDiscoveryNode((TransportAddress)allArguments[0]);
            return ret;
        }

        public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        }
    }

    public static class AddTransportAddressesInterceptor
    implements InstanceMethodsAroundInterceptor {
        public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        }

        public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
            TransportClientEnhanceInfo transportClientEnhanceInfo = (TransportClientEnhanceInfo)objInst.getSkyWalkingDynamicField();
            TransportAddressCache transportAddressCache = transportClientEnhanceInfo.getTransportAddressCache();
            if (transportAddressCache == null) {
                transportAddressCache = new TransportAddressCache();
                transportClientEnhanceInfo.setTransportAddressCache(transportAddressCache);
            }
            transportAddressCache.addDiscoveryNode((TransportAddress[])allArguments[0]);
            return ret;
        }

        public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        }
    }
}

