/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.lettuce.v5;

import java.util.function.BiConsumer;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class SWBiConsumer<T, U>
implements BiConsumer<T, U> {
    private BiConsumer<T, U> biConsumer;
    private ContextSnapshot snapshot;
    private String operationName;

    SWBiConsumer(BiConsumer<T, U> biConsumer, ContextSnapshot snapshot, String operationName) {
        this.biConsumer = biConsumer;
        this.snapshot = snapshot;
        this.operationName = operationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T t, U u) {
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationName + "/accept"));
        span.setComponent((Component)ComponentsDefine.LETTUCE);
        Tags.DB_TYPE.set(span, "Redis");
        SpanLayer.asCache((AbstractSpan)span);
        try {
            ContextManager.continued((ContextSnapshot)this.snapshot);
            this.biConsumer.accept(t, u);
        }
        catch (Throwable th) {
            ContextManager.activeSpan().log(th);
        }
        finally {
            ContextManager.stopSpan();
        }
    }
}

