/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.asynchttpclient.v2;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.InetSocketAddress;
import java.util.List;
import javax.net.ssl.SSLSession;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.netty.request.NettyRequest;

public class AsyncHandlerWrapper
implements AsyncHandler {
    private final AsyncHandler userAsyncHandler;
    private final AbstractSpan asyncSpan;
    private static final ILog LOGGER = LogManager.getLogger(AsyncHandlerWrapper.class);

    public AsyncHandlerWrapper(AsyncHandler asyncHandler, AbstractSpan span) {
        this.userAsyncHandler = asyncHandler == null ? new AsyncCompletionHandlerBase() : asyncHandler;
        this.asyncSpan = span;
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus httpResponseStatus) throws Exception {
        int statusCode = httpResponseStatus.getStatusCode();
        Tags.STATUS_CODE.set(this.asyncSpan, String.valueOf(statusCode));
        if (statusCode >= 400) {
            this.asyncSpan.errorOccurred();
        }
        return this.userAsyncHandler.onStatusReceived(httpResponseStatus);
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders httpHeaders) throws Exception {
        return this.userAsyncHandler.onHeadersReceived(httpHeaders);
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart httpResponseBodyPart) throws Exception {
        return this.userAsyncHandler.onBodyPartReceived(httpResponseBodyPart);
    }

    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers) throws Exception {
        return this.userAsyncHandler.onTrailingHeadersReceived(headers);
    }

    public void onThrowable(Throwable throwable) {
        try {
            this.asyncSpan.log(throwable);
            this.asyncSpan.asyncFinish();
        }
        catch (Exception e) {
            LOGGER.error("Failed to notify the async span stop.", (Throwable)e);
        }
        this.userAsyncHandler.onThrowable(throwable);
    }

    public Object onCompleted() throws Exception {
        try {
            this.asyncSpan.asyncFinish();
        }
        catch (Exception e) {
            LOGGER.error("Failed to notify the async span stop.", (Throwable)e);
        }
        return this.userAsyncHandler.onCompleted();
    }

    public void onHostnameResolutionAttempt(String name) {
        this.userAsyncHandler.onHostnameResolutionAttempt(name);
    }

    public void onHostnameResolutionFailure(String name, Throwable cause) {
        this.userAsyncHandler.onHostnameResolutionFailure(name, cause);
    }

    public void onTcpConnectAttempt(InetSocketAddress remoteAddress) {
        this.userAsyncHandler.onTcpConnectAttempt(remoteAddress);
    }

    public void onTcpConnectSuccess(InetSocketAddress remoteAddress, Channel connection) {
        this.userAsyncHandler.onTcpConnectSuccess(remoteAddress, connection);
    }

    public void onTcpConnectFailure(InetSocketAddress remoteAddress, Throwable cause) {
        this.userAsyncHandler.onTcpConnectFailure(remoteAddress, cause);
    }

    public void onTlsHandshakeAttempt() {
        this.userAsyncHandler.onTlsHandshakeAttempt();
    }

    public void onTlsHandshakeSuccess(SSLSession sslSession) {
        this.userAsyncHandler.onTlsHandshakeSuccess(sslSession);
    }

    public void onTlsHandshakeFailure(Throwable cause) {
        this.userAsyncHandler.onTlsHandshakeFailure(cause);
    }

    public void onConnectionPoolAttempt() {
        this.userAsyncHandler.onConnectionPoolAttempt();
    }

    public void onConnectionPooled(Channel connection) {
        this.userAsyncHandler.onConnectionPooled(connection);
    }

    public void onConnectionOffer(Channel connection) {
        this.userAsyncHandler.onConnectionOffer(connection);
    }

    public void onRequestSend(NettyRequest request) {
        this.userAsyncHandler.onRequestSend(request);
    }

    public void onRetry() {
        this.userAsyncHandler.onRetry();
    }

    public void onHostnameResolutionSuccess(String name, List list) {
        this.userAsyncHandler.onHostnameResolutionSuccess(name, list);
    }
}

