/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.feign.http.v9;

import feign.RequestTemplate;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.feign.http.v9.FeignResolvedURL;

public class PathVarInterceptor
implements InstanceMethodsAroundInterceptor {
    static final ThreadLocal<FeignResolvedURL> URL_CONTEXT = new ThreadLocal();

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        RequestTemplate template = (RequestTemplate)allArguments[1];
        URL_CONTEXT.set(new FeignResolvedURL(template.url()));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        RequestTemplate resolvedTemplate = (RequestTemplate)ret;
        URL_CONTEXT.get().setUrl(resolvedTemplate.url());
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (URL_CONTEXT.get() != null) {
            URL_CONTEXT.remove();
        }
    }
}

