/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.acl.AclOperation;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.acl.AclPermissionType;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.CommonFields;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Struct;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.resource.PatternType;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.resource.ResourcePattern;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.resource.ResourceType;

public final class RequestUtils {
    private RequestUtils() {
    }

    static ResourcePattern resourcePatternromStructFields(Struct struct) {
        byte resourceType = struct.get(CommonFields.RESOURCE_TYPE);
        String name = struct.get(CommonFields.RESOURCE_NAME);
        PatternType patternType = PatternType.fromCode(struct.getOrElse(CommonFields.RESOURCE_PATTERN_TYPE, PatternType.LITERAL.code()));
        return new ResourcePattern(ResourceType.fromCode(resourceType), name, patternType);
    }

    static void resourcePatternSetStructFields(ResourcePattern pattern, Struct struct) {
        struct.set(CommonFields.RESOURCE_TYPE, pattern.resourceType().code());
        struct.set(CommonFields.RESOURCE_NAME, pattern.name());
        struct.setIfExists(CommonFields.RESOURCE_PATTERN_TYPE, (Object)pattern.patternType().code());
    }

    static ResourcePatternFilter resourcePatternFilterFromStructFields(Struct struct) {
        byte resourceType = struct.get(CommonFields.RESOURCE_TYPE);
        String name = struct.get(CommonFields.RESOURCE_NAME_FILTER);
        PatternType patternType = PatternType.fromCode(struct.getOrElse(CommonFields.RESOURCE_PATTERN_TYPE_FILTER, PatternType.LITERAL.code()));
        return new ResourcePatternFilter(ResourceType.fromCode(resourceType), name, patternType);
    }

    static void resourcePatternFilterSetStructFields(ResourcePatternFilter patternFilter, Struct struct) {
        struct.set(CommonFields.RESOURCE_TYPE, patternFilter.resourceType().code());
        struct.set(CommonFields.RESOURCE_NAME_FILTER, patternFilter.name());
        struct.setIfExists(CommonFields.RESOURCE_PATTERN_TYPE_FILTER, (Object)patternFilter.patternType().code());
    }

    static AccessControlEntry aceFromStructFields(Struct struct) {
        String principal = struct.get(CommonFields.PRINCIPAL);
        String host = struct.get(CommonFields.HOST);
        byte operation = struct.get(CommonFields.OPERATION);
        byte permissionType = struct.get(CommonFields.PERMISSION_TYPE);
        return new AccessControlEntry(principal, host, AclOperation.fromCode(operation), AclPermissionType.fromCode(permissionType));
    }

    static void aceSetStructFields(AccessControlEntry data, Struct struct) {
        struct.set(CommonFields.PRINCIPAL, data.principal());
        struct.set(CommonFields.HOST, data.host());
        struct.set(CommonFields.OPERATION, data.operation().code());
        struct.set(CommonFields.PERMISSION_TYPE, data.permissionType().code());
    }

    static AccessControlEntryFilter aceFilterFromStructFields(Struct struct) {
        String principal = struct.get(CommonFields.PRINCIPAL_FILTER);
        String host = struct.get(CommonFields.HOST_FILTER);
        byte operation = struct.get(CommonFields.OPERATION);
        byte permissionType = struct.get(CommonFields.PERMISSION_TYPE);
        return new AccessControlEntryFilter(principal, host, AclOperation.fromCode(operation), AclPermissionType.fromCode(permissionType));
    }

    static void aceFilterSetStructFields(AccessControlEntryFilter filter, Struct struct) {
        struct.set(CommonFields.PRINCIPAL_FILTER, filter.principal());
        struct.set(CommonFields.HOST_FILTER, filter.host());
        struct.set(CommonFields.OPERATION, filter.operation().code());
        struct.set(CommonFields.PERMISSION_TYPE, filter.permissionType().code());
    }

    static void setLeaderEpochIfExists(Struct struct, Field.Int32 leaderEpochField, Optional<Integer> leaderEpoch) {
        struct.setIfExists(leaderEpochField, (Object)leaderEpoch.orElse(-1));
    }

    static Optional<Integer> getLeaderEpoch(Struct struct, Field.Int32 leaderEpochField) {
        int leaderEpoch = struct.getOrElse(leaderEpochField, -1);
        Optional<Integer> leaderEpochOpt = leaderEpoch == -1 ? Optional.empty() : Optional.of(leaderEpoch);
        return leaderEpochOpt;
    }

    static Optional<Integer> getLeaderEpoch(int leaderEpoch) {
        Optional<Integer> leaderEpochOpt = leaderEpoch == -1 ? Optional.empty() : Optional.of(leaderEpoch);
        return leaderEpochOpt;
    }

    public static ByteBuffer serialize(Struct headerStruct, Struct bodyStruct) {
        ByteBuffer buffer = ByteBuffer.allocate(headerStruct.sizeOf() + bodyStruct.sizeOf());
        headerStruct.writeTo(buffer);
        bodyStruct.writeTo(buffer);
        buffer.rewind();
        return buffer;
    }
}

