/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.FieldOrMethod;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.Type;

public final class Field
extends FieldOrMethod {
    public static final Field[] NoFields = new Field[0];
    private Type fieldType = null;

    private Field() {
    }

    public Field(Field c) {
        super(c);
    }

    Field(DataInputStream file, ConstantPool constant_pool) throws IOException {
        super(file, constant_pool);
    }

    public Field(int accessflags, int nameIndex, int signatureIndex, Attribute[] attributes, ConstantPool constant_pool) {
        super(accessflags, nameIndex, signatureIndex, attributes, constant_pool);
    }

    public void accept(ClassVisitor v) {
        v.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        return AttributeUtils.getConstantValueAttribute(this.attributes);
    }

    public final String toString() {
        String access = Utility.accessToString(this.modifiers);
        access = access.equals("") ? "" : String.valueOf(access) + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuffer buf = new StringBuffer(access);
        buf.append(signature).append(" ").append(name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = ").append(cv);
        }
        int i = 0;
        while (i < this.attributes.length) {
            Attribute a = this.attributes[i];
            if (!(a instanceof ConstantValue)) {
                buf.append(" [").append(a.toString()).append("]");
            }
            ++i;
        }
        return buf.toString();
    }

    public final Field copy(ConstantPool constant_pool) {
        return (Field)this.copy_(constant_pool);
    }

    public Type getType() {
        if (this.fieldType == null) {
            this.fieldType = Type.getReturnType(this.getSignature());
        }
        return this.fieldType;
    }
}

