/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Socket;
import java.nio.charset.Charset;
import py4j.NetworkUtil;

public class EchoClient {
    private int port = 25333;
    private Socket clientSocket;
    private Reader reader;
    private BufferedWriter writer;
    private char[] buffer = new char[4092];

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void write(String command) throws IOException {
        this.writer.write(command);
        this.writer.flush();
    }

    public String getResponse() throws IOException {
        int count = this.reader.read(this.buffer);
        return new String(this.buffer, 0, count);
    }

    public void connect() throws IOException {
        this.clientSocket = new Socket("127.0.0.1", this.port);
        this.reader = new InputStreamReader(this.clientSocket.getInputStream(), Charset.forName("UTF-8"));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream(), Charset.forName("UTF-8")));
    }

    public void close() {
        NetworkUtil.quietlyClose(this.reader);
        NetworkUtil.quietlyClose(this.writer);
        NetworkUtil.quietlyClose(this.clientSocket);
    }
}

