/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

public class CharOperation {
    public static final char[] subarray(char[] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final int lastIndexOf(char toBeFound, char[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (toBeFound != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(char toBeFound, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (toBeFound != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static final char[] concat(char[] first, char[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[] result = new char[length1 + length2];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static final boolean equals(char[] first, char[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static final void replace(char[] array, char toBeReplaced, char replacementChar) {
        if (toBeReplaced != replacementChar) {
            int max = array.length;
            for (int i = 0; i < max; ++i) {
                if (array[i] != toBeReplaced) continue;
                array[i] = replacementChar;
            }
        }
    }
}

