/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;

public class SequenceStrategy
implements Serializable {
    public static final SequenceStrategy NONTRANSACTIONAL = new SequenceStrategy(1);
    public static final SequenceStrategy CONTIGUOUS = new SequenceStrategy(2);
    public static final SequenceStrategy NONCONTIGUOUS = new SequenceStrategy(3);
    private final int typeId;

    private SequenceStrategy(int i) {
        this.typeId = i;
    }

    public boolean equals(Object o) {
        if (o instanceof SequenceStrategy) {
            return ((SequenceStrategy)o).typeId == this.typeId;
        }
        return false;
    }

    public String toString() {
        switch (this.typeId) {
            case 1: {
                return "nontransactional";
            }
            case 2: {
                return "contiguous";
            }
            case 3: {
                return "noncontiguous";
            }
        }
        return "";
    }

    public int getType() {
        return this.typeId;
    }

    public static SequenceStrategy getStrategy(String value) {
        if (value == null) {
            return null;
        }
        if (NONTRANSACTIONAL.toString().equalsIgnoreCase(value)) {
            return NONTRANSACTIONAL;
        }
        if (CONTIGUOUS.toString().equalsIgnoreCase(value)) {
            return CONTIGUOUS;
        }
        if (NONCONTIGUOUS.toString().equalsIgnoreCase(value)) {
            return NONCONTIGUOUS;
        }
        return null;
    }
}

