/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Table
implements TBase<Table, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Table");
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField OWNER_FIELD_DESC = new TField("owner", 11, 3);
    private static final TField CREATE_TIME_FIELD_DESC = new TField("createTime", 8, 4);
    private static final TField LAST_ACCESS_TIME_FIELD_DESC = new TField("lastAccessTime", 8, 5);
    private static final TField RETENTION_FIELD_DESC = new TField("retention", 8, 6);
    private static final TField SD_FIELD_DESC = new TField("sd", 12, 7);
    private static final TField PARTITION_KEYS_FIELD_DESC = new TField("partitionKeys", 15, 8);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 9);
    private String tableName;
    private String dbName;
    private String owner;
    private int createTime;
    private int lastAccessTime;
    private int retention;
    private StorageDescriptor sd;
    private List<FieldSchema> partitionKeys;
    private Map<String, String> parameters;
    private static final int __CREATETIME_ISSET_ID = 0;
    private static final int __LASTACCESSTIME_ISSET_ID = 1;
    private static final int __RETENTION_ISSET_ID = 2;
    private BitSet __isset_bit_vector = new BitSet(3);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Table() {
    }

    public Table(String tableName, String dbName, String owner, int createTime, int lastAccessTime, int retention, StorageDescriptor sd, List<FieldSchema> partitionKeys, Map<String, String> parameters) {
        this();
        this.tableName = tableName;
        this.dbName = dbName;
        this.owner = owner;
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
        this.retention = retention;
        this.setRetentionIsSet(true);
        this.sd = sd;
        this.partitionKeys = partitionKeys;
        this.parameters = parameters;
    }

    public Table(Table other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetOwner()) {
            this.owner = other.owner;
        }
        this.createTime = other.createTime;
        this.lastAccessTime = other.lastAccessTime;
        this.retention = other.retention;
        if (other.isSetSd()) {
            this.sd = new StorageDescriptor(other.sd);
        }
        if (other.isSetPartitionKeys()) {
            ArrayList<FieldSchema> __this__partitionKeys = new ArrayList<FieldSchema>();
            for (FieldSchema fieldSchema : other.partitionKeys) {
                __this__partitionKeys.add(new FieldSchema(fieldSchema));
            }
            this.partitionKeys = __this__partitionKeys;
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>();
            for (Map.Entry entry : other.parameters.entrySet()) {
                String other_element_key = (String)entry.getKey();
                String other_element_value = (String)entry.getValue();
                String __this__parameters_copy_key = other_element_key;
                String __this__parameters_copy_value = other_element_value;
                __this__parameters.put(__this__parameters_copy_key, __this__parameters_copy_value);
            }
            this.parameters = __this__parameters;
        }
    }

    public Table deepCopy() {
        return new Table(this);
    }

    public void clear() {
        this.tableName = null;
        this.dbName = null;
        this.owner = null;
        this.setCreateTimeIsSet(false);
        this.createTime = 0;
        this.setLastAccessTimeIsSet(false);
        this.lastAccessTime = 0;
        this.setRetentionIsSet(false);
        this.retention = 0;
        this.sd = null;
        this.partitionKeys = null;
        this.parameters = null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void unsetOwner() {
        this.owner = null;
    }

    public boolean isSetOwner() {
        return this.owner != null;
    }

    public void setOwnerIsSet(boolean value) {
        if (!value) {
            this.owner = null;
        }
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
    }

    public void unsetCreateTime() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetCreateTime() {
        return this.__isset_bit_vector.get(0);
    }

    public void setCreateTimeIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
    }

    public void unsetLastAccessTime() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetLastAccessTime() {
        return this.__isset_bit_vector.get(1);
    }

    public void setLastAccessTimeIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public int getRetention() {
        return this.retention;
    }

    public void setRetention(int retention) {
        this.retention = retention;
        this.setRetentionIsSet(true);
    }

    public void unsetRetention() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetRetention() {
        return this.__isset_bit_vector.get(2);
    }

    public void setRetentionIsSet(boolean value) {
        this.__isset_bit_vector.set(2, value);
    }

    public StorageDescriptor getSd() {
        return this.sd;
    }

    public void setSd(StorageDescriptor sd) {
        this.sd = sd;
    }

    public void unsetSd() {
        this.sd = null;
    }

    public boolean isSetSd() {
        return this.sd != null;
    }

    public void setSdIsSet(boolean value) {
        if (!value) {
            this.sd = null;
        }
    }

    public int getPartitionKeysSize() {
        return this.partitionKeys == null ? 0 : this.partitionKeys.size();
    }

    public Iterator<FieldSchema> getPartitionKeysIterator() {
        return this.partitionKeys == null ? null : this.partitionKeys.iterator();
    }

    public void addToPartitionKeys(FieldSchema elem) {
        if (this.partitionKeys == null) {
            this.partitionKeys = new ArrayList<FieldSchema>();
        }
        this.partitionKeys.add(elem);
    }

    public List<FieldSchema> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(List<FieldSchema> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public void unsetPartitionKeys() {
        this.partitionKeys = null;
    }

    public boolean isSetPartitionKeys() {
        return this.partitionKeys != null;
    }

    public void setPartitionKeysIsSet(boolean value) {
        if (!value) {
            this.partitionKeys = null;
        }
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setParametersIsSet(boolean value) {
        if (!value) {
            this.parameters = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case OWNER: {
                if (value == null) {
                    this.unsetOwner();
                    break;
                }
                this.setOwner((String)value);
                break;
            }
            case CREATE_TIME: {
                if (value == null) {
                    this.unsetCreateTime();
                    break;
                }
                this.setCreateTime((Integer)value);
                break;
            }
            case LAST_ACCESS_TIME: {
                if (value == null) {
                    this.unsetLastAccessTime();
                    break;
                }
                this.setLastAccessTime((Integer)value);
                break;
            }
            case RETENTION: {
                if (value == null) {
                    this.unsetRetention();
                    break;
                }
                this.setRetention((Integer)value);
                break;
            }
            case SD: {
                if (value == null) {
                    this.unsetSd();
                    break;
                }
                this.setSd((StorageDescriptor)value);
                break;
            }
            case PARTITION_KEYS: {
                if (value == null) {
                    this.unsetPartitionKeys();
                    break;
                }
                this.setPartitionKeys((List)value);
                break;
            }
            case PARAMETERS: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE_NAME: {
                return this.getTableName();
            }
            case DB_NAME: {
                return this.getDbName();
            }
            case OWNER: {
                return this.getOwner();
            }
            case CREATE_TIME: {
                return new Integer(this.getCreateTime());
            }
            case LAST_ACCESS_TIME: {
                return new Integer(this.getLastAccessTime());
            }
            case RETENTION: {
                return new Integer(this.getRetention());
            }
            case SD: {
                return this.getSd();
            }
            case PARTITION_KEYS: {
                return this.getPartitionKeys();
            }
            case PARAMETERS: {
                return this.getParameters();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case DB_NAME: {
                return this.isSetDbName();
            }
            case OWNER: {
                return this.isSetOwner();
            }
            case CREATE_TIME: {
                return this.isSetCreateTime();
            }
            case LAST_ACCESS_TIME: {
                return this.isSetLastAccessTime();
            }
            case RETENTION: {
                return this.isSetRetention();
            }
            case SD: {
                return this.isSetSd();
            }
            case PARTITION_KEYS: {
                return this.isSetPartitionKeys();
            }
            case PARAMETERS: {
                return this.isSetParameters();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Table) {
            return this.equals((Table)that);
        }
        return false;
    }

    public boolean equals(Table that) {
        if (that == null) {
            return false;
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_owner = this.isSetOwner();
        boolean that_present_owner = that.isSetOwner();
        if (this_present_owner || that_present_owner) {
            if (!this_present_owner || !that_present_owner) {
                return false;
            }
            if (!this.owner.equals(that.owner)) {
                return false;
            }
        }
        boolean this_present_createTime = true;
        boolean that_present_createTime = true;
        if (this_present_createTime || that_present_createTime) {
            if (!this_present_createTime || !that_present_createTime) {
                return false;
            }
            if (this.createTime != that.createTime) {
                return false;
            }
        }
        boolean this_present_lastAccessTime = true;
        boolean that_present_lastAccessTime = true;
        if (this_present_lastAccessTime || that_present_lastAccessTime) {
            if (!this_present_lastAccessTime || !that_present_lastAccessTime) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
        }
        boolean this_present_retention = true;
        boolean that_present_retention = true;
        if (this_present_retention || that_present_retention) {
            if (!this_present_retention || !that_present_retention) {
                return false;
            }
            if (this.retention != that.retention) {
                return false;
            }
        }
        boolean this_present_sd = this.isSetSd();
        boolean that_present_sd = that.isSetSd();
        if (this_present_sd || that_present_sd) {
            if (!this_present_sd || !that_present_sd) {
                return false;
            }
            if (!this.sd.equals(that.sd)) {
                return false;
            }
        }
        boolean this_present_partitionKeys = this.isSetPartitionKeys();
        boolean that_present_partitionKeys = that.isSetPartitionKeys();
        if (this_present_partitionKeys || that_present_partitionKeys) {
            if (!this_present_partitionKeys || !that_present_partitionKeys) {
                return false;
            }
            if (!((Object)this.partitionKeys).equals(that.partitionKeys)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!((Object)this.parameters).equals(that.parameters)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(Table other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        Table typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(typedOther.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)typedOther.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDbName()).compareTo(typedOther.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)typedOther.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOwner()).compareTo(typedOther.isSetOwner());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwner() && (lastComparison = TBaseHelper.compareTo((String)this.owner, (String)typedOther.owner)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreateTime()).compareTo(typedOther.isSetCreateTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateTime() && (lastComparison = TBaseHelper.compareTo((int)this.createTime, (int)typedOther.createTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLastAccessTime()).compareTo(typedOther.isSetLastAccessTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastAccessTime() && (lastComparison = TBaseHelper.compareTo((int)this.lastAccessTime, (int)typedOther.lastAccessTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRetention()).compareTo(typedOther.isSetRetention());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRetention() && (lastComparison = TBaseHelper.compareTo((int)this.retention, (int)typedOther.retention)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSd()).compareTo(typedOther.isSetSd());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSd() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sd), (Comparable)((Object)typedOther.sd))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPartitionKeys()).compareTo(typedOther.isSetPartitionKeys());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionKeys() && (lastComparison = TBaseHelper.compareTo(this.partitionKeys, typedOther.partitionKeys)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParameters()).compareTo(typedOther.isSetParameters());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, typedOther.parameters)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.tableName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.dbName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.owner = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 8) {
                        this.createTime = iprot.readI32();
                        this.setCreateTimeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.lastAccessTime = iprot.readI32();
                        this.setLastAccessTimeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 6: {
                    if (field.type == 8) {
                        this.retention = iprot.readI32();
                        this.setRetentionIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 7: {
                    if (field.type == 12) {
                        this.sd = new StorageDescriptor();
                        this.sd.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 8: {
                    if (field.type == 15) {
                        TList _list26 = iprot.readListBegin();
                        this.partitionKeys = new ArrayList<FieldSchema>(_list26.size);
                        for (int _i27 = 0; _i27 < _list26.size; ++_i27) {
                            FieldSchema _elem28 = new FieldSchema();
                            _elem28.read(iprot);
                            this.partitionKeys.add(_elem28);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 9: {
                    if (field.type == 13) {
                        TMap _map29 = iprot.readMapBegin();
                        this.parameters = new HashMap<String, String>(2 * _map29.size);
                        for (int _i30 = 0; _i30 < _map29.size; ++_i30) {
                            String _key31 = iprot.readString();
                            String _val32 = iprot.readString();
                            this.parameters.put(_key31, _val32);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.tableName != null) {
            oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
            oprot.writeString(this.tableName);
            oprot.writeFieldEnd();
        }
        if (this.dbName != null) {
            oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
            oprot.writeString(this.dbName);
            oprot.writeFieldEnd();
        }
        if (this.owner != null) {
            oprot.writeFieldBegin(OWNER_FIELD_DESC);
            oprot.writeString(this.owner);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(CREATE_TIME_FIELD_DESC);
        oprot.writeI32(this.createTime);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LAST_ACCESS_TIME_FIELD_DESC);
        oprot.writeI32(this.lastAccessTime);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(RETENTION_FIELD_DESC);
        oprot.writeI32(this.retention);
        oprot.writeFieldEnd();
        if (this.sd != null) {
            oprot.writeFieldBegin(SD_FIELD_DESC);
            this.sd.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.partitionKeys != null) {
            oprot.writeFieldBegin(PARTITION_KEYS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.partitionKeys.size()));
            for (FieldSchema fieldSchema : this.partitionKeys) {
                fieldSchema.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.parameters != null) {
            oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.parameters.size()));
            for (Map.Entry entry : this.parameters.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table(");
        boolean first = true;
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("owner:");
        if (this.owner == null) {
            sb.append("null");
        } else {
            sb.append(this.owner);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("createTime:");
        sb.append(this.createTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastAccessTime:");
        sb.append(this.lastAccessTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("retention:");
        sb.append(this.retention);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sd:");
        if (this.sd == null) {
            sb.append("null");
        } else {
            sb.append(this.sd);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("partitionKeys:");
        if (this.partitionKeys == null) {
            sb.append("null");
        } else {
            sb.append(this.partitionKeys);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OWNER, new FieldMetaData("owner", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATE_TIME, new FieldMetaData("createTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.LAST_ACCESS_TIME, new FieldMetaData("lastAccessTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.RETENTION, new FieldMetaData("retention", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SD, new FieldMetaData("sd", 3, (FieldValueMetaData)new StructMetaData(12, StorageDescriptor.class)));
        tmpMap.put(_Fields.PARTITION_KEYS, new FieldMetaData("partitionKeys", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, FieldSchema.class))));
        tmpMap.put(_Fields.PARAMETERS, new FieldMetaData("parameters", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Table.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE_NAME(1, "tableName"),
        DB_NAME(2, "dbName"),
        OWNER(3, "owner"),
        CREATE_TIME(4, "createTime"),
        LAST_ACCESS_TIME(5, "lastAccessTime"),
        RETENTION(6, "retention"),
        SD(7, "sd"),
        PARTITION_KEYS(8, "partitionKeys"),
        PARAMETERS(9, "parameters");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE_NAME;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return OWNER;
                }
                case 4: {
                    return CREATE_TIME;
                }
                case 5: {
                    return LAST_ACCESS_TIME;
                }
                case 6: {
                    return RETENTION;
                }
                case 7: {
                    return SD;
                }
                case 8: {
                    return PARTITION_KEYS;
                }
                case 9: {
                    return PARAMETERS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

