/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.api.Adjacency;
import org.apache.hadoop.hive.ql.plan.api.NodeType;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Graph
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Graph");
    private static final TField NODE_TYPE_FIELD_DESC = new TField("nodeType", 8, 1);
    private static final TField ROOTS_FIELD_DESC = new TField("roots", 15, 2);
    private static final TField ADJACENCY_LIST_FIELD_DESC = new TField("adjacencyList", 15, 3);
    private int nodeType;
    public static final int NODETYPE = 1;
    private List<String> roots;
    public static final int ROOTS = 2;
    private List<Adjacency> adjacencyList;
    public static final int ADJACENCYLIST = 3;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("nodeType", 3, new FieldValueMetaData(8)));
            this.put(2, new FieldMetaData("roots", 3, new ListMetaData(15, new FieldValueMetaData(11))));
            this.put(3, new FieldMetaData("adjacencyList", 3, new ListMetaData(15, new StructMetaData(12, Adjacency.class))));
        }
    });

    public Graph() {
    }

    public Graph(int nodeType, List<String> roots, List<Adjacency> adjacencyList) {
        this();
        this.nodeType = nodeType;
        this.__isset.nodeType = true;
        this.roots = roots;
        this.adjacencyList = adjacencyList;
    }

    public Graph(Graph other) {
        this.__isset.nodeType = other.__isset.nodeType;
        this.nodeType = other.nodeType;
        if (other.isSetRoots()) {
            ArrayList<String> __this__roots = new ArrayList<String>();
            for (String string : other.roots) {
                __this__roots.add(string);
            }
            this.roots = __this__roots;
        }
        if (other.isSetAdjacencyList()) {
            ArrayList<Adjacency> __this__adjacencyList = new ArrayList<Adjacency>();
            for (Adjacency adjacency : other.adjacencyList) {
                __this__adjacencyList.add(new Adjacency(adjacency));
            }
            this.adjacencyList = __this__adjacencyList;
        }
    }

    public Graph clone() {
        return new Graph(this);
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
        this.__isset.nodeType = true;
    }

    public void unsetNodeType() {
        this.__isset.nodeType = false;
    }

    public boolean isSetNodeType() {
        return this.__isset.nodeType;
    }

    public int getRootsSize() {
        return this.roots == null ? 0 : this.roots.size();
    }

    public Iterator<String> getRootsIterator() {
        return this.roots == null ? null : this.roots.iterator();
    }

    public void addToRoots(String elem) {
        if (this.roots == null) {
            this.roots = new ArrayList<String>();
        }
        this.roots.add(elem);
    }

    public List<String> getRoots() {
        return this.roots;
    }

    public void setRoots(List<String> roots) {
        this.roots = roots;
    }

    public void unsetRoots() {
        this.roots = null;
    }

    public boolean isSetRoots() {
        return this.roots != null;
    }

    public int getAdjacencyListSize() {
        return this.adjacencyList == null ? 0 : this.adjacencyList.size();
    }

    public Iterator<Adjacency> getAdjacencyListIterator() {
        return this.adjacencyList == null ? null : this.adjacencyList.iterator();
    }

    public void addToAdjacencyList(Adjacency elem) {
        if (this.adjacencyList == null) {
            this.adjacencyList = new ArrayList<Adjacency>();
        }
        this.adjacencyList.add(elem);
    }

    public List<Adjacency> getAdjacencyList() {
        return this.adjacencyList;
    }

    public void setAdjacencyList(List<Adjacency> adjacencyList) {
        this.adjacencyList = adjacencyList;
    }

    public void unsetAdjacencyList() {
        this.adjacencyList = null;
    }

    public boolean isSetAdjacencyList() {
        return this.adjacencyList != null;
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetNodeType();
                    break;
                }
                this.setNodeType((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetRoots();
                    break;
                }
                this.setRoots((List)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetAdjacencyList();
                    break;
                }
                this.setAdjacencyList((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getNodeType();
            }
            case 2: {
                return this.getRoots();
            }
            case 3: {
                return this.getAdjacencyList();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetNodeType();
            }
            case 2: {
                return this.isSetRoots();
            }
            case 3: {
                return this.isSetAdjacencyList();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Graph) {
            return this.equals((Graph)that);
        }
        return false;
    }

    public boolean equals(Graph that) {
        if (that == null) {
            return false;
        }
        boolean this_present_nodeType = true;
        boolean that_present_nodeType = true;
        if (this_present_nodeType || that_present_nodeType) {
            if (!this_present_nodeType || !that_present_nodeType) {
                return false;
            }
            if (this.nodeType != that.nodeType) {
                return false;
            }
        }
        boolean this_present_roots = this.isSetRoots();
        boolean that_present_roots = that.isSetRoots();
        if (this_present_roots || that_present_roots) {
            if (!this_present_roots || !that_present_roots) {
                return false;
            }
            if (!((Object)this.roots).equals(that.roots)) {
                return false;
            }
        }
        boolean this_present_adjacencyList = this.isSetAdjacencyList();
        boolean that_present_adjacencyList = that.isSetAdjacencyList();
        if (this_present_adjacencyList || that_present_adjacencyList) {
            if (!this_present_adjacencyList || !that_present_adjacencyList) {
                return false;
            }
            if (!((Object)this.adjacencyList).equals(that.adjacencyList)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.nodeType = iprot.readI32();
                        this.__isset.nodeType = true;
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list4 = iprot.readListBegin();
                        this.roots = new ArrayList<String>(_list4.size);
                        for (int _i5 = 0; _i5 < _list4.size; ++_i5) {
                            String _elem6 = iprot.readString();
                            this.roots.add(_elem6);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 15) {
                        TList _list7 = iprot.readListBegin();
                        this.adjacencyList = new ArrayList<Adjacency>(_list7.size);
                        for (int _i8 = 0; _i8 < _list7.size; ++_i8) {
                            Adjacency _elem9 = new Adjacency();
                            _elem9.read(iprot);
                            this.adjacencyList.add(_elem9);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(NODE_TYPE_FIELD_DESC);
        oprot.writeI32(this.nodeType);
        oprot.writeFieldEnd();
        if (this.roots != null) {
            oprot.writeFieldBegin(ROOTS_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.roots.size()));
            for (String _iter10 : this.roots) {
                oprot.writeString(_iter10);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.adjacencyList != null) {
            oprot.writeFieldBegin(ADJACENCY_LIST_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.adjacencyList.size()));
            for (Adjacency _iter11 : this.adjacencyList) {
                _iter11.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Graph(");
        boolean first = true;
        sb.append("nodeType:");
        String nodeType_name = NodeType.VALUES_TO_NAMES.get(this.nodeType);
        if (nodeType_name != null) {
            sb.append(nodeType_name);
            sb.append(" (");
        }
        sb.append(this.nodeType);
        if (nodeType_name != null) {
            sb.append(")");
        }
        if (!(first = false)) {
            sb.append(", ");
        }
        sb.append("roots:");
        if (this.roots == null) {
            sb.append("null");
        } else {
            sb.append(this.roots);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("adjacencyList:");
        if (this.adjacencyList == null) {
            sb.append("null");
        } else {
            sb.append(this.adjacencyList);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetNodeType() && !NodeType.VALID_VALUES.contains(this.nodeType)) {
            throw new TProtocolException("The field 'nodeType' has been assigned the invalid value " + this.nodeType);
        }
    }

    static {
        FieldMetaData.addStructMetaDataMap(Graph.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        public boolean nodeType = false;

        private Isset() {
        }
    }
}

