/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.jdbc.HiveConnection;

public class HiveDriver
implements Driver {
    private static final int MAJOR_VERSION = 0;
    private static final int MINOR_VERSION = 0;
    private static final boolean JDBC_COMPLIANT = false;
    private static final String URL_PREFIX = "jdbc:hive://";
    private static final String DEFAULT_PORT = "10000";
    private static final String DBNAME_PROPERTY_KEY = "DBNAME";
    private static final String HOST_PROPERTY_KEY = "HOST";
    private static final String PORT_PROPERTY_KEY = "PORT";

    public HiveDriver() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite("foobah");
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.matches("jdbc:hive://.*", url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return new HiveConnection(url, info);
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith(URL_PREFIX)) {
            info = this.parseURL(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo(HOST_PROPERTY_KEY, info.getProperty(HOST_PROPERTY_KEY, ""));
        hostProp.required = false;
        hostProp.description = "Hostname of Hive Server";
        DriverPropertyInfo portProp = new DriverPropertyInfo(PORT_PROPERTY_KEY, info.getProperty(PORT_PROPERTY_KEY, ""));
        portProp.required = false;
        portProp.description = "Port number of Hive Server";
        DriverPropertyInfo dbProp = new DriverPropertyInfo(DBNAME_PROPERTY_KEY, info.getProperty(DBNAME_PROPERTY_KEY, "default"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp};
        return dpi;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private Properties parseURL(String url, Properties defaults) throws SQLException {
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? new Properties(defaults) : new Properties();
        if (url == null || !url.startsWith(URL_PREFIX)) {
            throw new SQLException("Invalid connection url: " + url);
        }
        if (url.length() <= URL_PREFIX.length()) {
            return urlProps;
        }
        String connectionInfo = url.substring(URL_PREFIX.length());
        String[] hostPortAndDatabase = connectionInfo.split("/", 2);
        if (hostPortAndDatabase[0].length() > 0) {
            String[] hostAndPort = hostPortAndDatabase[0].split(":", 2);
            urlProps.put(HOST_PROPERTY_KEY, hostAndPort[0]);
            if (hostAndPort.length > 1) {
                urlProps.put(PORT_PROPERTY_KEY, hostAndPort[1]);
            } else {
                urlProps.put(PORT_PROPERTY_KEY, DEFAULT_PORT);
            }
        }
        if (hostPortAndDatabase.length > 1) {
            urlProps.put(DBNAME_PROPERTY_KEY, hostPortAndDatabase[1]);
        }
        return urlProps;
    }

    static {
        try {
            DriverManager.registerDriver(new HiveDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

