/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fb303;

import com.facebook.fb303.FacebookService;
import com.facebook.fb303.fb_status;
import java.util.AbstractMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FacebookBase
implements FacebookService.Iface {
    private String name_;
    private long alive_;
    private final ConcurrentHashMap<String, Long> counters_ = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> options_ = new ConcurrentHashMap();

    protected FacebookBase(String name) {
        this.name_ = name;
        this.alive_ = System.currentTimeMillis() / 1000L;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public abstract fb_status getStatus();

    @Override
    public String getStatusDetails() {
        return "";
    }

    public void deleteCounter(String key) {
        this.counters_.remove(key);
    }

    public void resetCounter(String key) {
        this.counters_.put(key, 0L);
    }

    public long incrementCounter(String key) {
        long val = this.getCounter(key) + 1L;
        this.counters_.put(key, val);
        return val;
    }

    public AbstractMap<String, Long> getCounters() {
        return this.counters_;
    }

    @Override
    public long getCounter(String key) {
        Long val = this.counters_.get(key);
        if (val == null) {
            return 0L;
        }
        return val;
    }

    @Override
    public void setOption(String key, String value) {
        this.options_.put(key, value);
    }

    @Override
    public String getOption(String key) {
        return this.options_.get(key);
    }

    public AbstractMap<String, String> getOptions() {
        return this.options_;
    }

    @Override
    public long aliveSince() {
        return this.alive_;
    }

    public String getCpuProfile() {
        return "";
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public void shutdown() {
    }
}

