/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.Openable;
import org.aspectj.org.eclipse.jdt.internal.core.OverflowingLRUCache;
import org.aspectj.org.eclipse.jdt.internal.core.util.LRUCache;

public class ElementCache
extends OverflowingLRUCache {
    IJavaElement spaceLimitParent = null;

    public ElementCache(int size) {
        super(size);
    }

    public ElementCache(int size, int overflow) {
        super(size, overflow);
    }

    protected boolean close(LRUCache.LRUCacheEntry entry) {
        Openable element;
        block5: {
            element = (Openable)entry._fKey;
            try {
                if (element.canBeRemovedFromCache()) break block5;
                return false;
            }
            catch (JavaModelException npe) {
                return false;
            }
        }
        if (element instanceof JarPackageFragment) {
            JarPackageFragment packageFragment = (JarPackageFragment)element;
            JarPackageFragmentRoot root = (JarPackageFragmentRoot)packageFragment.getParent();
            root.close();
        } else {
            element.close();
        }
        return true;
    }

    protected void ensureSpaceLimit(int childrenSize, IJavaElement parent) {
        int spaceNeeded = 1 + (int)((1.0 + this.fLoadFactor) * (double)(childrenSize + this.fOverflow));
        if (this.fSpaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    protected LRUCache newInstance(int size, int overflow) {
        return new ElementCache(size, overflow);
    }

    protected void resetSpaceLimit(int defaultLimit, IJavaElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }
}

