/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.util.apachelogparser;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class DateExtractor
extends EvalFunc<String> {
    private static String DEFAULT_INCOMING_DATE_FORMAT = "dd/MMM/yyyy:HH:mm:ss Z";
    private static String DEFAULT_OUTGOING_DATE_FORMAT = "yyyy-MM-dd";
    private static String DEFAULT_TZ_ID = "GMT";
    private SimpleDateFormat incomingDateFormat;
    private SimpleDateFormat outgoingDateFormat;

    public DateExtractor() {
        this(DEFAULT_INCOMING_DATE_FORMAT, DEFAULT_OUTGOING_DATE_FORMAT, DEFAULT_TZ_ID);
    }

    public DateExtractor(String outgoingDateString) {
        this(DEFAULT_INCOMING_DATE_FORMAT, outgoingDateString, "GMT");
    }

    public DateExtractor(String incomingDateString, String outgoingDateString) {
        this(incomingDateString, outgoingDateString, DEFAULT_TZ_ID);
    }

    public DateExtractor(String incomingDateString, String outgoingDateString, String timeZoneID) {
        TimeZone tz = TimeZone.getTimeZone(timeZoneID);
        this.incomingDateFormat = new SimpleDateFormat(incomingDateString);
        this.outgoingDateFormat = new SimpleDateFormat(outgoingDateString);
        this.incomingDateFormat.setTimeZone(tz);
        this.outgoingDateFormat.setTimeZone(tz);
    }

    public String exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        String str = "";
        try {
            str = (String)input.get(0);
            Date date = this.incomingDateFormat.parse(str);
            return this.outgoingDateFormat.format(date);
        }
        catch (ParseException pe) {
            System.err.println("piggybank.evaluation.util.apachelogparser.DateExtractor: unable to parse date " + str);
            return null;
        }
        catch (Exception e) {
            throw new IOException("Caught exception processing input row ", e);
        }
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 55))));
        return funcList;
    }
}

