/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.PseudoToken;
import org.aspectj.ajdt.internal.compiler.ast.PseudoTokens;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.Pointcut;

public class PointcutDesignator
extends ASTNode {
    private Pointcut pointcut;
    private PseudoTokens tokens;
    private boolean isError = false;

    public PointcutDesignator(Parser parser, PseudoTokens tokens) {
        this.sourceStart = tokens.sourceStart;
        this.sourceEnd = tokens.sourceEnd;
        this.tokens = tokens;
        Pointcut pc = tokens.parsePointcut(parser);
        if (pc.toString().equals("")) {
            this.isError = true;
        }
        this.pointcut = pc;
    }

    public PointcutDesignator(Pointcut pc) {
        this.pointcut = pc;
    }

    public void postParse(TypeDeclaration typeDec, MethodDeclaration enclosingDec) {
        if (this.tokens != null) {
            this.tokens.postParse(typeDec, enclosingDec);
        }
    }

    public boolean finishResolveTypes(AbstractMethodDeclaration dec, MethodBinding method, int baseArgumentCount, SourceTypeBinding sourceTypeBinding) {
        if (this.pointcut.state == Pointcut.RESOLVED || this.pointcut.state == Pointcut.CONCRETE) {
            return true;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(dec.scope);
        TypeBinding[] parameters = method.parameters;
        Argument[] arguments = dec.arguments;
        FormalBinding[] bindings = new FormalBinding[baseArgumentCount];
        int len = baseArgumentCount;
        for (int i = 0; i < len; ++i) {
            TypeVariableBinding[] tvs;
            Argument arg = arguments[i];
            String name = new String(arg.name);
            UnresolvedType type = world.fromBinding(parameters[i]);
            if (parameters[i].isInterface() && parameters[i].isParameterizedType() && parameters[i].isMemberType() && ((tvs = parameters[i].typeVariables()) == null || tvs.length == 0)) {
                type = type.getRawType();
            }
            bindings[i] = new FormalBinding(type, name, i, arg.sourceStart, arg.sourceEnd);
        }
        EclipseScope scope = new EclipseScope(bindings, dec.scope);
        this.pointcut = this.pointcut.resolve(scope);
        return true;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public String getPointcutDeclarationText() {
        StringBuffer sb = new StringBuffer();
        PseudoToken[] toks = this.tokens.tokens;
        for (int i = 0; i < toks.length - 1; ++i) {
            sb.append(toks[i].getString());
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean isError() {
        return this.isError;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        if (this.pointcut == null) {
            return output.append("<pcd>");
        }
        return output.append(this.pointcut.toString());
    }
}

