/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;

public class DfsProcessor
implements CommandProcessor {
    public static final Log LOG = LogFactory.getLog((String)DfsProcessor.class.getName());
    public static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private FsShell dfs;

    public DfsProcessor(Configuration conf) {
        this.dfs = new FsShell(conf);
    }

    @Override
    public void init() {
    }

    @Override
    public int run(String command) {
        String[] tokens = command.split("\\s+");
        try {
            int ret;
            SessionState ss = SessionState.get();
            PrintStream oldOut = System.out;
            if (ss != null && ss.out != null) {
                System.setOut(ss.out);
            }
            if ((ret = this.dfs.run(tokens)) != 0) {
                console.printError("Command failed with exit code = " + ret);
            }
            System.setOut(oldOut);
            return ret;
        }
        catch (Exception e) {
            console.printError("Exception raised from DFSShell.run " + e.getLocalizedMessage(), StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }
}

