/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

public class SessionState {
    protected HiveConf conf;
    protected boolean isSilent;
    protected HiveHistory hiveHist;
    public InputStream in;
    public PrintStream out;
    public PrintStream err;
    public PrintStream childOut;
    public PrintStream childErr;
    private String commandType;
    private static ThreadLocal<SessionState> tss = new ThreadLocal();
    public static final String HIVE_L4J = "hive-log4j.properties";
    private static LogHelper _console;
    private final Map<ResourceType, HashMap<String, ResourceHook>> resourceMap = new EnumMap<ResourceType, HashMap<String, ResourceHook>>(ResourceType.class);

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public boolean getIsSilent() {
        return this.isSilent;
    }

    public void setIsSilent(boolean isSilent) {
        this.isSilent = isSilent;
    }

    public SessionState() {
        this(null);
    }

    public SessionState(HiveConf conf) {
        this.conf = conf;
        for (ResourceType t : ResourceType.values()) {
            this.resourceMap.put(t, new HashMap());
        }
    }

    public void setCmd(String cmdString) {
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYSTRING, cmdString);
    }

    public String getCmd() {
        return this.conf.getVar(HiveConf.ConfVars.HIVEQUERYSTRING);
    }

    public String getQueryId() {
        return this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID);
    }

    public String getSessionId() {
        return this.conf.getVar(HiveConf.ConfVars.HIVESESSIONID);
    }

    public static SessionState start(HiveConf conf) {
        SessionState ss = new SessionState(conf);
        ss.getConf().setVar(HiveConf.ConfVars.HIVESESSIONID, SessionState.makeSessionId());
        ss.hiveHist = new HiveHistory(ss);
        tss.set(ss);
        return ss;
    }

    public static SessionState start(SessionState startSs) {
        tss.set(startSs);
        if (StringUtils.isEmpty(startSs.getConf().getVar(HiveConf.ConfVars.HIVESESSIONID))) {
            startSs.getConf().setVar(HiveConf.ConfVars.HIVESESSIONID, SessionState.makeSessionId());
        }
        if (startSs.hiveHist == null) {
            startSs.hiveHist = new HiveHistory(startSs);
        }
        return startSs;
    }

    public static SessionState get() {
        return tss.get();
    }

    public HiveHistory getHiveHistory() {
        return this.hiveHist;
    }

    private static String makeSessionId() {
        GregorianCalendar gc = new GregorianCalendar();
        String userid = System.getProperty("user.name");
        return userid + "_" + String.format("%1$4d%2$02d%3$02d%4$02d%5$02d", gc.get(1), gc.get(2) + 1, gc.get(5), gc.get(11), gc.get(12));
    }

    public static void initHiveLog4j() {
        URL hive_l4j = SessionState.class.getClassLoader().getResource(HIVE_L4J);
        if (hive_l4j == null) {
            System.out.println("hive-log4j.properties not found");
        } else {
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((URL)hive_l4j);
        }
    }

    public static LogHelper getConsole() {
        if (_console == null) {
            Log LOG = LogFactory.getLog((String)"SessionState");
            _console = new LogHelper(LOG);
        }
        return _console;
    }

    public static String validateFile(String newFile) {
        SessionState ss = SessionState.get();
        LogHelper console = SessionState.getConsole();
        Configuration conf = ss == null ? new Configuration() : ss.getConf();
        try {
            if (Utilities.realFile(newFile, conf) != null) {
                return newFile;
            }
            console.printError(newFile + " does not exist");
            return null;
        }
        catch (IOException e) {
            console.printError("Unable to validate " + newFile + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    public static boolean registerJar(String newJar) {
        LogHelper console = SessionState.getConsole();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(Utilities.addToClassPath(loader, StringUtils.split(newJar, ",")));
            console.printInfo("Added " + newJar + " to class path");
            return true;
        }
        catch (Exception e) {
            console.printError("Unable to register " + newJar + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public static boolean unregisterJar(String jarToUnregister) {
        LogHelper console = SessionState.getConsole();
        try {
            Utilities.removeFromClassPath(new String[]{jarToUnregister});
            console.printInfo("Deleted " + jarToUnregister + " from class path");
            return true;
        }
        catch (Exception e) {
            console.printError("Unable to unregister " + jarToUnregister + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public static ResourceType find_resource_type(String s) {
        s = s.trim().toUpperCase();
        try {
            return ResourceType.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            if (!s.endsWith("S")) {
                return null;
            }
            s = s.substring(0, s.length() - 1);
            try {
                return ResourceType.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public void add_resource(ResourceType t, String value) {
        if (this.resourceMap.get((Object)t).containsKey(value)) {
            SessionState.getConsole().printError("Resource " + value + " already added.");
            return;
        }
        ResourceHook hook = t.makeHook(value);
        if (hook.preHook()) {
            this.resourceMap.get((Object)t).put(value, hook);
        }
    }

    public boolean delete_resource(ResourceType t, String value) {
        ResourceHook h = this.resourceMap.get((Object)t).get(value);
        if (h != null && h.postHook()) {
            this.resourceMap.get((Object)t).remove(value);
            return true;
        }
        return false;
    }

    public Set<String> list_resource(ResourceType t, List<String> filter) {
        if (this.resourceMap.get((Object)t) == null) {
            return null;
        }
        Set<String> orig = this.resourceMap.get((Object)t).keySet();
        if (filter == null) {
            return orig;
        }
        HashSet<String> fnl = new HashSet<String>();
        for (String one : orig) {
            if (!filter.contains(one)) continue;
            fnl.add(one);
        }
        return fnl;
    }

    public void delete_resource(ResourceType t) {
        for (String value : this.resourceMap.get((Object)t).keySet()) {
            this.delete_resource(t, value);
        }
        if (!this.resourceMap.get((Object)t).isEmpty()) {
            SessionState.getConsole().printInfo("Force-clearing resource map for resource type: " + (Object)((Object)t));
            this.resourceMap.put(t, new HashMap());
        }
    }

    public String getCommandType() {
        return this.commandType;
    }

    public void setCommandType(String commandType) {
        this.commandType = commandType;
    }

    public Set<String> listLocalJarResources() {
        HashSet<String> ret = new HashSet<String>();
        for (ResourceHook hook : this.resourceMap.get((Object)ResourceType.JAR).values()) {
            JarResourceHook h = (JarResourceHook)hook;
            ret.add(h.getLocalFile());
        }
        return ret;
    }

    public static enum ResourceType {
        FILE,
        JAR,
        ARCHIVE;


        public ResourceHook makeHook(String file) {
            switch (this) {
                case FILE: 
                case ARCHIVE: {
                    return new FileResourceHook(file);
                }
                case JAR: {
                    return new JarResourceHook(file);
                }
            }
            throw new IllegalArgumentException("Unrecognized resource type: " + (Object)((Object)this));
        }
    }

    static class JarResourceHook
    implements ResourceHook {
        private final String file;
        private File localFile = null;

        JarResourceHook(String file) {
            this.file = file;
        }

        @Override
        public boolean preHook() {
            String newJar = SessionState.validateFile(this.file);
            if (newJar != null) {
                HiveConf conf = SessionState.get().getConf();
                Path p = new Path(newJar);
                if (p.toUri().getScheme() != "file") {
                    LogHelper console = SessionState.getConsole();
                    File scratchDir = new File(conf.getVar(HiveConf.ConfVars.SCRATCHDIR));
                    try {
                        this.localFile = File.createTempFile(p.getName(), ".jar", scratchDir);
                        console.printInfo("Copying " + newJar + " to " + this.localFile);
                        FileSystem.get((URI)p.toUri(), (Configuration)conf).copyToLocalFile(p, new Path(this.localFile.toURI().toString()));
                    }
                    catch (IOException e) {
                        console.printError("Failed to load jar resource: " + e.toString());
                        if (this.localFile != null) {
                            this.localFile.delete();
                        }
                        return false;
                    }
                    newJar = this.localFile.getPath();
                }
                if (!SessionState.registerJar(newJar)) {
                    if (this.localFile != null) {
                        this.localFile.delete();
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean postHook() {
            if (this.localFile != null) {
                boolean ret = SessionState.unregisterJar(this.localFile.toString());
                this.localFile.delete();
                return ret;
            }
            return SessionState.unregisterJar(this.file);
        }

        public String getLocalFile() {
            return this.localFile.getPath();
        }
    }

    static class FileResourceHook
    implements ResourceHook {
        private final String file;

        FileResourceHook(String file) {
            this.file = file;
        }

        @Override
        public boolean preHook() {
            return null != SessionState.validateFile(this.file);
        }

        @Override
        public boolean postHook() {
            return true;
        }
    }

    public static interface ResourceHook {
        public boolean preHook();

        public boolean postHook();
    }

    public static class LogHelper {
        protected Log LOG;
        protected boolean isSilent;

        public LogHelper(Log LOG) {
            this(LOG, false);
        }

        public LogHelper(Log LOG, boolean isSilent) {
            this.LOG = LOG;
            this.isSilent = isSilent;
        }

        public PrintStream getOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.out != null ? ss.out : System.out;
        }

        public PrintStream getErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.err != null ? ss.err : System.err;
        }

        public PrintStream getChildOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childOut != null ? ss.childOut : System.out;
        }

        public PrintStream getChildErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childErr != null ? ss.childErr : System.err;
        }

        public boolean getIsSilent() {
            SessionState ss = SessionState.get();
            return ss != null ? ss.getIsSilent() : this.isSilent;
        }

        public void printInfo(String info) {
            this.printInfo(info, null);
        }

        public void printInfo(String info, String detail) {
            if (!this.getIsSilent()) {
                this.getErrStream().println(info);
            }
            this.LOG.info((Object)(info + StringUtils.defaultString(detail)));
        }

        public void printError(String error) {
            this.printError(error, null);
        }

        public void printError(String error, String detail) {
            this.getErrStream().println(error);
            this.LOG.error((Object)(error + StringUtils.defaultString(detail)));
        }
    }
}

