/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.hooks.PostExecute;
import org.apache.hadoop.hive.ql.hooks.PreExecute;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.plan.fetchWork;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;

public class Driver
implements CommandProcessor {
    private static final Log LOG = LogFactory.getLog((String)Driver.class.getName());
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private int maxRows = 100;
    ByteStream.Output bos = new ByteStream.Output();
    private HiveConf conf;
    private DataInput resStream;
    private Context ctx;
    private QueryPlan plan;
    private String errorMessage;
    private String SQLState;
    private int maxthreads = 8;
    private int sleeptime = 2000;

    @Override
    public void init() {
        Operator.resetId();
    }

    public int countJobs(List<Task<? extends Serializable>> tasks) {
        return this.countJobs(tasks, new ArrayList<Task<? extends Serializable>>());
    }

    public int countJobs(List<Task<? extends Serializable>> tasks, List<Task<? extends Serializable>> seenTasks) {
        if (tasks == null) {
            return 0;
        }
        int jobs = 0;
        for (Task<? extends Serializable> task : tasks) {
            if (seenTasks.contains(task)) continue;
            seenTasks.add(task);
            if (task.isMapRedTask()) {
                ++jobs;
            }
            jobs += this.countJobs(task.getChildTasks(), seenTasks);
        }
        return jobs;
    }

    public ClusterStatus getClusterStatus() throws Exception {
        ClusterStatus cs;
        try {
            JobConf job = new JobConf((Configuration)this.conf, ExecDriver.class);
            JobClient jc = new JobClient(job);
            cs = jc.getClusterStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning cluster status: " + cs.toString()));
        return cs;
    }

    public Schema getSchema() throws Exception {
        Schema schema;
        try {
            if (this.plan != null && this.plan.getPlan().getFetchTask() != null) {
                FetchTask ft;
                tableDesc td;
                BaseSemanticAnalyzer sem = this.plan.getPlan();
                if (!sem.getFetchTaskInit()) {
                    sem.setFetchTaskInit(true);
                    sem.getFetchTask().initialize(this.conf, this.plan);
                }
                if ((td = (ft = (FetchTask)sem.getFetchTask()).getTblDesc()) == null && ft.getWork() != null && ((fetchWork)ft.getWork()).getPartDesc() != null && ((fetchWork)ft.getWork()).getPartDesc().size() > 0) {
                    td = ((fetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
                }
                if (td == null) {
                    throw new Exception("No table description found for fetch task: " + ft);
                }
                String tableName = "result";
                List lst = MetaStoreUtils.getFieldsFromDeserializer((String)tableName, (Deserializer)td.getDeserializer());
                schema = new Schema(lst, null);
            } else {
                schema = new Schema();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning Hive schema: " + schema));
        return schema;
    }

    public Schema getThriftSchema() throws Exception {
        Schema schema;
        try {
            List lst;
            schema = this.getSchema();
            if (schema != null && (lst = schema.getFieldSchemas()) != null) {
                for (FieldSchema f : lst) {
                    f.setType(MetaStoreUtils.typeToThriftType((String)f.getType()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning Thrift schema: " + schema));
        return schema;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean hasReduceTasks(List<Task<? extends Serializable>> tasks) {
        if (tasks == null) {
            return false;
        }
        boolean hasReduce = false;
        for (Task<? extends Serializable> task : tasks) {
            if (task.hasReduce()) {
                return true;
            }
            hasReduce = hasReduce || this.hasReduceTasks(task.getChildTasks());
        }
        return hasReduce;
    }

    public Driver(HiveConf conf) {
        this.conf = conf;
        try {
            UnixUserGroupInformation.login((Configuration)conf, (boolean)true);
        }
        catch (Exception e) {
            LOG.warn((Object)("Ignoring " + e.getMessage()));
        }
    }

    public Driver() {
        if (SessionState.get() != null) {
            this.conf = SessionState.get().getConf();
            try {
                UnixUserGroupInformation.login((Configuration)this.conf, (boolean)true);
            }
            catch (Exception e) {
                LOG.warn((Object)("Ignoring " + e.getMessage()));
            }
        }
    }

    public int compile(String command) {
        if (this.plan != null) {
            this.close();
            this.plan = null;
        }
        TaskFactory.resetId();
        try {
            this.ctx = new Context(this.conf);
            ParseDriver pd = new ParseDriver();
            ASTNode tree = pd.parse(command);
            while (tree.getToken() == null && tree.getChildCount() > 0) {
                tree = (ASTNode)tree.getChild(0);
            }
            BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.conf, tree);
            sem.analyze(tree, this.ctx);
            LOG.info((Object)"Semantic Analysis Completed");
            sem.validate();
            this.plan = new QueryPlan(command, sem);
            return 0;
        }
        catch (SemanticException e) {
            this.errorMessage = "FAILED: Error in semantic analysis: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 10;
        }
        catch (ParseException e) {
            this.errorMessage = "FAILED: Parse Error: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 11;
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Unknown exception: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 12;
        }
    }

    public QueryPlan getPlan() {
        return this.plan;
    }

    @Override
    public int run(String command) {
        DriverResponse response = this.runCommand(command);
        return response.getResponseCode();
    }

    public DriverResponse runCommand(String command) {
        this.errorMessage = null;
        this.SQLState = null;
        int ret = this.compile(command);
        if (ret != 0) {
            return new DriverResponse(ret, this.errorMessage, this.SQLState);
        }
        ret = this.execute();
        if (ret != 0) {
            return new DriverResponse(ret, this.errorMessage, this.SQLState);
        }
        return new DriverResponse(ret);
    }

    private List<PreExecute> getPreExecHooks() throws Exception {
        String[] peClasses;
        ArrayList<PreExecute> pehooks = new ArrayList<PreExecute>();
        String pestr = this.conf.getVar(HiveConf.ConfVars.PREEXECHOOKS);
        if ((pestr = pestr.trim()).equals("")) {
            return pehooks;
        }
        for (String peClass : peClasses = pestr.split(",")) {
            try {
                pehooks.add((PreExecute)Class.forName(peClass.trim(), true, JavaUtils.getClassLoader()).newInstance());
            }
            catch (ClassNotFoundException e) {
                console.printError("Pre Exec Hook Class not found:" + e.getMessage());
                throw e;
            }
        }
        return pehooks;
    }

    private List<PostExecute> getPostExecHooks() throws Exception {
        String[] peClasses;
        ArrayList<PostExecute> pehooks = new ArrayList<PostExecute>();
        String pestr = this.conf.getVar(HiveConf.ConfVars.POSTEXECHOOKS);
        if ((pestr = pestr.trim()).equals("")) {
            return pehooks;
        }
        for (String peClass : peClasses = pestr.split(",")) {
            try {
                pehooks.add((PostExecute)Class.forName(peClass.trim(), true, JavaUtils.getClassLoader()).newInstance());
            }
            catch (ClassNotFoundException e) {
                console.printError("Post Exec Hook Class not found:" + e.getMessage());
                throw e;
            }
        }
        return pehooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        boolean noName = StringUtils.isEmpty(this.conf.getVar(HiveConf.ConfVars.HADOOPJOBNAME));
        int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
        int curJobNo = 0;
        String queryId = this.plan.getQueryId();
        String queryStr = this.plan.getQueryStr();
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYSTRING, queryStr);
        try {
            LOG.info((Object)("Starting command: " + queryStr));
            this.plan.setStarted();
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().startQuery(queryStr, this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                SessionState.get().getHiveHistory().logPlanProgress(this.plan);
            }
            this.resStream = null;
            BaseSemanticAnalyzer sem = this.plan.getPlan();
            for (PreExecute peh : this.getPreExecHooks()) {
                peh.run(SessionState.get(), sem.getInputs(), sem.getOutputs(), (UserGroupInformation)UnixUserGroupInformation.readFromConf((Configuration)this.conf, (String)"hadoop.job.ugi"));
            }
            int jobs = this.countJobs(sem.getRootTasks());
            if (jobs > 0) {
                console.printInfo("Total MapReduce jobs = " + jobs);
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_NUM_TASKS, String.valueOf(jobs));
                SessionState.get().getHiveHistory().setIdToTableMap(sem.getIdToTableNameMap());
            }
            String jobname = Utilities.abbreviate(queryStr, maxlen - 6);
            LinkedList<Task<? extends Serializable>> runnable = new LinkedList<Task<? extends Serializable>>();
            HashMap<TaskResult, TaskRunner> running = new HashMap<TaskResult, TaskRunner>();
            for (Task<? extends Serializable> tsk : sem.getRootTasks()) {
                this.addToRunnable(runnable, tsk);
            }
            while (running.size() != 0 || runnable.peek() != null) {
                while (runnable.peek() != null && running.size() < this.maxthreads) {
                    Task tsk = (Task)runnable.remove();
                    curJobNo = this.launchTask(tsk, queryId, noName, running, jobname, jobs, curJobNo);
                }
                TaskResult tskRes = this.pollTasks(running.keySet());
                TaskRunner tskRun = (TaskRunner)running.remove(tskRes);
                Task<? extends Serializable> tsk = tskRun.getTask();
                int exitVal = tskRes.getExitVal();
                if (exitVal != 0) {
                    this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
                    this.SQLState = "08S01";
                    console.printError(this.errorMessage);
                    if (running.size() != 0) {
                        this.taskCleanup();
                    }
                    int n = 9;
                    return n;
                }
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().setTaskProperty(queryId, tsk.getId(), HiveHistory.Keys.TASK_RET_CODE, String.valueOf(exitVal));
                    SessionState.get().getHiveHistory().endTask(queryId, tsk);
                }
                if (tsk.getChildTasks() == null) continue;
                for (Task<Serializable> child : tsk.getChildTasks()) {
                    if (!this.isLaunchable(child)) continue;
                    this.addToRunnable(runnable, child);
                }
            }
            for (PostExecute peh : this.getPostExecHooks()) {
                peh.run(SessionState.get(), sem.getInputs(), sem.getOutputs(), (UserGroupInformation)UnixUserGroupInformation.readFromConf((Configuration)this.conf, (String)"hadoop.job.ugi"));
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(0));
                SessionState.get().getHiveHistory().printRowCount(queryId);
            }
        }
        catch (Exception e) {
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(12));
            }
            this.errorMessage = "FAILED: Unknown exception : " + e.getMessage();
            this.SQLState = "08S01";
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 12;
            return n;
        }
        finally {
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().endQuery(queryId);
            }
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, "");
            }
        }
        this.plan.setDone();
        if (SessionState.get() != null) {
            try {
                SessionState.get().getHiveHistory().logPlanProgress(this.plan);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        console.printInfo("OK");
        return 0;
    }

    public int launchTask(Task<? extends Serializable> tsk, String queryId, boolean noName, Map<TaskResult, TaskRunner> running, String jobname, int jobs, int curJobNo) {
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().startTask(queryId, tsk, tsk.getClass().getName());
        }
        if (tsk.isMapRedTask()) {
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, jobname + "(" + tsk.getId() + ")");
            }
            console.printInfo("Launching Job " + ++curJobNo + " out of " + jobs);
        }
        tsk.initialize(this.conf, this.plan);
        TaskResult tskRes = new TaskResult();
        TaskRunner tskRun = new TaskRunner(tsk, tskRes);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.EXECPARALLEL) && tsk.isMapRedTask()) {
            tskRun.start();
        } else {
            tskRun.runSequential();
        }
        running.put(tskRes, tskRun);
        return curJobNo;
    }

    public void taskCleanup() {
        System.exit(9);
    }

    public TaskResult pollTasks(Set<TaskResult> results) {
        Iterator<TaskResult> resultIterator = results.iterator();
        while (true) {
            if (resultIterator.hasNext()) {
                TaskResult tskRes = resultIterator.next();
                if (tskRes.isRunning()) continue;
                return tskRes;
            }
            try {
                Thread.sleep(this.sleeptime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resultIterator = results.iterator();
        }
    }

    public boolean isLaunchable(Task<? extends Serializable> tsk) {
        return !tsk.getQueued() && !tsk.getInitialized() && tsk.isRunnable();
    }

    public void addToRunnable(Queue<Task<? extends Serializable>> runnable, Task<? extends Serializable> tsk) {
        runnable.add(tsk);
        tsk.setQueued();
    }

    public boolean getResults(Vector<String> res) throws IOException {
        if (this.plan != null && this.plan.getPlan().getFetchTask() != null) {
            BaseSemanticAnalyzer sem = this.plan.getPlan();
            if (!sem.getFetchTaskInit()) {
                sem.setFetchTaskInit(true);
                sem.getFetchTask().initialize(this.conf, this.plan);
            }
            FetchTask ft = (FetchTask)sem.getFetchTask();
            ft.setMaxRows(this.maxRows);
            return ft.fetch(res);
        }
        if (this.resStream == null) {
            this.resStream = this.ctx.getStream();
        }
        if (this.resStream == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.streamStatus ss;
            if (this.resStream == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.resStream, this.bos);
                if (this.bos.getCount() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getCount(), "UTF-8");
                } else if (ss == Utilities.streamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
            }
            catch (IOException e) {
                console.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                res = null;
                return false;
            }
            if (ss != Utilities.streamStatus.EOF) continue;
            this.resStream = this.ctx.getStream();
        }
        return true;
    }

    public int close() {
        try {
            this.ctx.clear();
        }
        catch (Exception e) {
            console.printError("FAILED: Unknown exception : " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 13;
        }
        return 0;
    }

    public Query getQueryPlan() throws IOException {
        return this.plan.getQueryPlan();
    }

    public class DriverResponse {
        private int responseCode;
        private String errorMessage;
        private String SQLState;

        public DriverResponse(int responseCode) {
            this(responseCode, null, null);
        }

        public DriverResponse(int responseCode, String errorMessage, String SQLState) {
            this.responseCode = responseCode;
            this.errorMessage = errorMessage;
            this.SQLState = SQLState;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getSQLState() {
            return this.SQLState;
        }
    }
}

