/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.fetchWork;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;

public class FetchTask
extends Task<fetchWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int maxRows = 100;
    private FetchOperator ftOp;
    private LazySimpleSerDe mSerde;
    private int totalRows;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan) {
        super.initialize(conf, queryPlan);
        try {
            JobConf job = new JobConf((Configuration)conf, ExecDriver.class);
            this.mSerde = new LazySimpleSerDe();
            Properties mSerdeProp = new Properties();
            mSerdeProp.put("serialization.format", "9");
            mSerdeProp.put("serialization.null.format", ((fetchWork)this.work).getSerializationNullFormat());
            this.mSerde.initialize((Configuration)job, mSerdeProp);
            this.mSerde.setUseJSONSerialize(true);
            this.ftOp = new FetchOperator((fetchWork)this.work, job);
        }
        catch (Exception e) {
            this.LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public int execute() {
        assert (false);
        return 0;
    }

    public tableDesc getTblDesc() {
        return ((fetchWork)this.work).getTblDesc();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public boolean fetch(Vector<String> res) throws IOException {
        try {
            int numRows = 0;
            int rowsRet = this.maxRows;
            if (((fetchWork)this.work).getLimit() >= 0 && ((fetchWork)this.work).getLimit() - this.totalRows < rowsRet) {
                rowsRet = ((fetchWork)this.work).getLimit() - this.totalRows;
            }
            if (rowsRet <= 0) {
                this.ftOp.clearFetchContext();
                return false;
            }
            while (numRows < rowsRet) {
                InspectableObject io = this.ftOp.getNextRow();
                if (io == null) {
                    if (numRows == 0) {
                        return false;
                    }
                    this.totalRows += numRows;
                    return true;
                }
                res.add(((Text)this.mSerde.serialize(io.o, io.oi)).toString());
                ++numRows;
            }
            this.totalRows += numRows;
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getType() {
        return 5;
    }
}

