/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.reduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class ReduceSinkOperator
extends TerminalOperator<reduceSinkDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ExprNodeEvaluator[] keyEval;
    protected transient ExprNodeEvaluator[] valueEval;
    protected transient ExprNodeEvaluator[] partitionEval;
    transient Serializer keySerializer;
    transient boolean keyIsText;
    transient Serializer valueSerializer;
    transient int tag;
    transient byte[] tagByte = new byte[1];
    transient InspectableObject tempInspectableObject = new InspectableObject();
    transient HiveKey keyWritable = new HiveKey();
    transient Writable value;
    transient StructObjectInspector keyObjectInspector;
    transient StructObjectInspector valueObjectInspector;
    transient ObjectInspector[] partitionObjectInspectors;
    transient Object[] cachedKeys;
    transient Object[] cachedValues;
    boolean firstRow;
    transient Random random;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.keyEval = new ExprNodeEvaluator[((reduceSinkDesc)this.conf).getKeyCols().size()];
            int i = 0;
            for (exprNodeDesc e : ((reduceSinkDesc)this.conf).getKeyCols()) {
                this.keyEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.valueEval = new ExprNodeEvaluator[((reduceSinkDesc)this.conf).getValueCols().size()];
            i = 0;
            for (exprNodeDesc e : ((reduceSinkDesc)this.conf).getValueCols()) {
                this.valueEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.partitionEval = new ExprNodeEvaluator[((reduceSinkDesc)this.conf).getPartitionCols().size()];
            i = 0;
            for (exprNodeDesc e : ((reduceSinkDesc)this.conf).getPartitionCols()) {
                this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.tag = ((reduceSinkDesc)this.conf).getTag();
            this.tagByte[0] = (byte)this.tag;
            this.LOG.info((Object)("Using tag = " + this.tag));
            tableDesc keyTableDesc = ((reduceSinkDesc)this.conf).getKeySerializeInfo();
            this.keySerializer = (Serializer)((Object)keyTableDesc.getDeserializerClass().newInstance());
            this.keySerializer.initialize(null, keyTableDesc.getProperties());
            this.keyIsText = this.keySerializer.getSerializedClass().equals(Text.class);
            tableDesc valueTableDesc = ((reduceSinkDesc)this.conf).getValueSerializeInfo();
            this.valueSerializer = (Serializer)((Object)valueTableDesc.getDeserializerClass().newInstance());
            this.valueSerializer.initialize(null, valueTableDesc.getProperties());
            this.firstRow = true;
            this.initializeChildren(hconf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            int i;
            int keyLength;
            Text key;
            ObjectInspector rowInspector = this.inputObjInspectors[tag];
            if (this.firstRow) {
                this.firstRow = false;
                this.keyObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.keyEval, ((reduceSinkDesc)this.conf).getOutputKeyColumnNames(), rowInspector);
                this.valueObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.valueEval, ((reduceSinkDesc)this.conf).getOutputValueColumnNames(), rowInspector);
                this.partitionObjectInspectors = ReduceSinkOperator.initEvaluators(this.partitionEval, rowInspector);
                this.cachedKeys = new Object[this.keyEval.length];
                this.cachedValues = new Object[this.valueEval.length];
            }
            for (int i2 = 0; i2 < this.keyEval.length; ++i2) {
                this.cachedKeys[i2] = this.keyEval[i2].evaluate(row);
            }
            if (this.keyIsText) {
                key = (Text)this.keySerializer.serialize(this.cachedKeys, this.keyObjectInspector);
                if (tag == -1) {
                    this.keyWritable.set(key.getBytes(), 0, key.getLength());
                } else {
                    keyLength = key.getLength();
                    this.keyWritable.setSize(keyLength + 1);
                    System.arraycopy(key.getBytes(), 0, this.keyWritable.get(), 0, keyLength);
                    this.keyWritable.get()[keyLength] = this.tagByte[0];
                }
            } else {
                key = (BytesWritable)this.keySerializer.serialize(this.cachedKeys, this.keyObjectInspector);
                if (tag == -1) {
                    this.keyWritable.set(key.get(), 0, key.getSize());
                } else {
                    keyLength = key.getSize();
                    this.keyWritable.setSize(keyLength + 1);
                    System.arraycopy(key.get(), 0, this.keyWritable.get(), 0, keyLength);
                    this.keyWritable.get()[keyLength] = this.tagByte[0];
                }
            }
            int keyHashCode = 0;
            if (this.partitionEval.length == 0) {
                if (this.random == null) {
                    this.random = new Random(12345L);
                }
                keyHashCode = this.random.nextInt();
            } else {
                for (i = 0; i < this.partitionEval.length; ++i) {
                    Object o = this.partitionEval[i].evaluate(row);
                    keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode(o, this.partitionObjectInspectors[i]);
                }
            }
            this.keyWritable.setHashCode(keyHashCode);
            for (i = 0; i < this.valueEval.length; ++i) {
                this.cachedValues[i] = this.valueEval[i].evaluate(row);
            }
            this.value = this.valueSerializer.serialize(this.cachedValues, this.valueObjectInspector);
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
        try {
            if (this.out != null) {
                this.out.collect((Object)this.keyWritable, (Object)this.value);
                if (this.counterNameToEnum != null) {
                    ++this.outputRows;
                    if (this.outputRows % 1000L == 0L) {
                        this.incrCounter(numOutputRowsCntr, this.outputRows);
                        this.outputRows = 0L;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public String getName() {
        return new String("RS");
    }

    @Override
    public int getType() {
        return 11;
    }
}

