/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class RowContainer<Row extends List> {
    protected Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private static final int BLOCKSIZE = 25000;
    private static final int BLKMETA_LEN = 100;
    private Row[] lastBlock;
    private Row[] currBlock;
    private int blockSize;
    private int numBlocks;
    private int size;
    private File tmpFile;
    private RandomAccessFile rFile;
    private long[] off_len;
    private int itrCursor;
    private int addCursor;
    private int pBlock;
    private SerDe serde;
    private ObjectInspector standardOI;
    private ArrayList dummyRow;

    public RowContainer() {
        this(25000);
    }

    public RowContainer(int blockSize) {
        this.blockSize = blockSize == 0 ? 25000 : blockSize;
        this.size = 0;
        this.itrCursor = 0;
        this.addCursor = 0;
        this.numBlocks = 0;
        this.pBlock = 0;
        this.tmpFile = null;
        this.lastBlock = new ArrayList[blockSize];
        this.currBlock = this.lastBlock;
        this.off_len = new long[200];
        this.serde = null;
        this.standardOI = null;
        this.dummyRow = new ArrayList(0);
    }

    public RowContainer(int blockSize, SerDe sd, ObjectInspector oi) {
        this(blockSize);
        this.setSerDe(sd, oi);
    }

    public void setSerDe(SerDe sd, ObjectInspector oi) {
        assert (this.serde != null) : "serde is null";
        assert (oi != null) : "oi is null";
        this.serde = sd;
        this.standardOI = oi;
    }

    public void add(Row t) throws HiveException {
        if (this.addCursor >= this.blockSize) {
            this.spillBlock((List[])this.lastBlock);
            this.addCursor = 0;
            if (this.numBlocks == 1) {
                this.lastBlock = new ArrayList[this.blockSize];
            }
        }
        this.lastBlock[this.addCursor++] = t;
        ++this.size;
    }

    public Row first() {
        if (this.size == 0) {
            return null;
        }
        if (this.pBlock > 0) {
            this.pBlock = 0;
            this.currBlock = this.getBlock(0);
            assert (this.currBlock != null) : "currBlock == null";
        }
        if (this.currBlock == null && this.lastBlock != null) {
            this.currBlock = this.lastBlock;
        }
        assert (this.pBlock == 0) : "pBlock != 0 ";
        this.itrCursor = 1;
        return this.currBlock[0];
    }

    public Row next() {
        assert (this.pBlock <= this.numBlocks) : "pBlock " + this.pBlock + " > numBlocks" + this.numBlocks;
        if (this.pBlock < this.numBlocks) {
            if (this.itrCursor < this.blockSize) {
                return this.currBlock[this.itrCursor++];
            }
            if (++this.pBlock < this.numBlocks) {
                this.currBlock = this.getBlock(this.pBlock);
                assert (this.currBlock != null) : "currBlock == null";
                this.itrCursor = 1;
                return this.currBlock[0];
            }
            this.itrCursor = 0;
            this.currBlock = this.lastBlock;
        }
        if (this.itrCursor < this.addCursor) {
            return this.currBlock[this.itrCursor++];
        }
        return null;
    }

    private void spillBlock(Row[] block) throws HiveException {
        try {
            if (this.tmpFile == null) {
                this.tmpFile = File.createTempFile("RowContainer", ".tmp", new File("/tmp"));
                this.LOG.info((Object)("RowContainer created temp file " + this.tmpFile.getAbsolutePath()));
                this.tmpFile.deleteOnExit();
                this.rFile = new RandomAccessFile(this.tmpFile, "rw");
            }
            byte[] buf = this.serialize((List[])block);
            long offset = this.rFile.length();
            long len = buf.length;
            this.rFile.seek(offset);
            this.rFile.write(buf);
            this.addBlockMetadata(offset, len);
        }
        catch (Exception e) {
            this.LOG.debug((Object)e.toString());
            throw new HiveException(e);
        }
    }

    private void addBlockMetadata(long offset, long len) {
        if ((this.numBlocks + 1) * 2 >= this.off_len.length) {
            this.off_len = Arrays.copyOf(this.off_len, this.off_len.length * 2);
        }
        this.off_len[this.numBlocks * 2] = offset;
        this.off_len[this.numBlocks * 2 + 1] = len;
        ++this.numBlocks;
    }

    private byte[] serialize(Row[] obj) throws HiveException {
        ByteArrayOutputStream baos;
        assert (this.serde != null && this.standardOI != null);
        try {
            baos = new ByteArrayOutputStream();
            DataOutputStream oos = new DataOutputStream(baos);
            oos.writeInt(obj.length);
            if (this.serde != null && this.standardOI != null) {
                for (int i = 0; i < obj.length; ++i) {
                    Writable outVal = this.serde.serialize(obj[i], this.standardOI);
                    outVal.write((DataOutput)oos);
                }
            }
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
        return baos.toByteArray();
    }

    private Row[] deserialize(byte[] buf) throws HiveException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            DataInputStream ois = new DataInputStream(bais);
            int sz = ois.readInt();
            assert (sz == this.blockSize) : "deserialized size " + sz + " is not the same as block size " + this.blockSize;
            List[] ret = new ArrayList[sz];
            for (int i = 0; i < sz; ++i) {
                if (this.serde != null && this.standardOI != null) {
                    Writable val = this.serde.getSerializedClass().newInstance();
                    val.readFields((DataInput)ois);
                    ret[i] = (List)ObjectInspectorUtils.copyToStandardObject(this.serde.deserialize(val), this.serde.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                    continue;
                }
                ret[i] = this.dummyRow;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() throws HiveException {
        this.itrCursor = 0;
        this.addCursor = 0;
        this.numBlocks = 0;
        this.pBlock = 0;
        this.size = 0;
        try {
            if (this.rFile != null) {
                this.rFile.close();
            }
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)e.toString());
            throw new HiveException(e);
        }
        this.tmpFile = null;
    }

    private Row[] getBlock(int block) {
        long offset = this.off_len[block * 2];
        long len = this.off_len[block * 2 + 1];
        byte[] buf = new byte[(int)len];
        try {
            this.rFile.seek(offset);
            this.rFile.readFully(buf);
            this.currBlock = this.deserialize(buf);
        }
        catch (Exception e) {
            this.LOG.error((Object)e.toString());
            return null;
        }
        return this.currBlock;
    }
}

