/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.InputFormat;

public class Table {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.metadata.Table");
    private Properties schema;
    private Deserializer deserializer;
    private URI uri;
    private Class<? extends InputFormat> inputFormatClass;
    private Class<? extends HiveOutputFormat> outputFormatClass;
    private org.apache.hadoop.hive.metastore.api.Table tTable;

    protected Table() throws HiveException {
    }

    public Table(String name, Properties schema, Deserializer deserializer, Class<? extends InputFormat<?, ?>> inputFormatClass, Class<?> outputFormatClass, URI dataLocation, Hive hive) throws HiveException {
        this.initEmpty();
        this.schema = schema;
        this.deserializer = deserializer;
        this.getTTable().getSd().getSerdeInfo().setSerializationLib(deserializer.getClass().getName());
        this.getTTable().setTableName(name);
        this.getSerdeInfo().setSerializationLib(deserializer.getClass().getName());
        this.setInputFormatClass(inputFormatClass);
        this.setOutputFormatClass(HiveFileFormatUtils.getOutputFormatSubstitute(outputFormatClass));
        this.setDataLocation(dataLocation);
    }

    public Table(String name) {
        this.initEmpty();
        this.getTTable().setTableName(name);
        this.getTTable().setDbName("default");
        this.getSerdeInfo().setSerializationLib(MetadataTypedColumnsetSerDe.class.getName());
        this.getSerdeInfo().getParameters().put("serialization.format", "1");
    }

    void initEmpty() {
        this.setTTable(new org.apache.hadoop.hive.metastore.api.Table());
        this.getTTable().setSd(new StorageDescriptor());
        this.getTTable().setPartitionKeys(new ArrayList());
        this.getTTable().setParameters(new HashMap());
        StorageDescriptor sd = this.getTTable().getSd();
        sd.setSerdeInfo(new SerDeInfo());
        sd.setNumBuckets(-1);
        sd.setBucketCols(new ArrayList());
        sd.setCols(new ArrayList());
        sd.setParameters(new HashMap());
        sd.setSortCols(new ArrayList());
        sd.getSerdeInfo().setParameters(new HashMap());
    }

    public void reinitSerDe() throws HiveException {
        try {
            this.deserializer = MetaStoreUtils.getDeserializer((Configuration)Hive.get().getConf(), (org.apache.hadoop.hive.metastore.api.Table)this.getTTable());
        }
        catch (MetaException e) {
            throw new HiveException(e);
        }
    }

    protected void initSerDe() throws HiveException {
        if (this.deserializer == null) {
            try {
                this.deserializer = MetaStoreUtils.getDeserializer((Configuration)Hive.get().getConf(), (org.apache.hadoop.hive.metastore.api.Table)this.getTTable());
            }
            catch (MetaException e) {
                throw new HiveException(e);
            }
        }
    }

    public void checkValidity() throws HiveException {
        String name = this.getTTable().getTableName();
        if (null == name || name.length() == 0 || !MetaStoreUtils.validateName((String)name)) {
            throw new HiveException("[" + name + "]: is not a valid table name");
        }
        if (0 == this.getCols().size()) {
            throw new HiveException("atleast one column must be specified for the table");
        }
        if (null == this.getDeserializer()) {
            throw new HiveException("must specify a non-null serDe");
        }
        if (null == this.getInputFormatClass()) {
            throw new HiveException("must specify an InputFormat class");
        }
        if (null == this.getOutputFormatClass()) {
            throw new HiveException("must specify an OutputFormat class");
        }
        Iterator<FieldSchema> iterCols = this.getCols().iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new HiveException("Duplicate column name " + colName + " in the table definition.");
            }
            colNames.add(colName.toLowerCase());
        }
        if (this.getPartCols() != null) {
            Iterator<FieldSchema> partColsIter = this.getPartCols().iterator();
            while (partColsIter.hasNext()) {
                String partCol = partColsIter.next().getName();
                if (!colNames.contains(partCol.toLowerCase())) continue;
                throw new HiveException("Partition column name " + partCol + " conflicts with table columns.");
            }
        }
    }

    public void setInputFormatClass(Class<? extends InputFormat> inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
        this.tTable.getSd().setInputFormat(inputFormatClass.getName());
    }

    public void setOutputFormatClass(Class<?> class1) {
        this.outputFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(class1);
        this.tTable.getSd().setOutputFormat(class1.getName());
    }

    public final Properties getSchema() {
        return this.schema;
    }

    public final Path getPath() {
        return new Path(this.getTTable().getSd().getLocation());
    }

    public final String getName() {
        return this.getTTable().getTableName();
    }

    public final URI getDataLocation() {
        return this.uri;
    }

    public final Deserializer getDeserializer() {
        if (this.deserializer == null) {
            try {
                this.initSerDe();
            }
            catch (HiveException e) {
                LOG.error((Object)"Error in initializing serde.", (Throwable)e);
            }
        }
        return this.deserializer;
    }

    public final Class<? extends InputFormat> getInputFormatClass() {
        return this.inputFormatClass;
    }

    public final Class<? extends HiveOutputFormat> getOutputFormatClass() {
        return this.outputFormatClass;
    }

    public final boolean isValidSpec(Map<String, String> spec) throws HiveException {
        List partCols = this.getTTable().getPartitionKeys();
        if (partCols == null || partCols.size() == 0) {
            if (spec != null) {
                throw new HiveException("table is not partitioned but partition spec exists: " + spec);
            }
            return true;
        }
        if (spec == null || spec.size() != partCols.size()) {
            throw new HiveException("table is partitioned but partition spec is not specified or tab: " + spec);
        }
        for (FieldSchema field : partCols) {
            if (spec.get(field.getName()) != null) continue;
            throw new HiveException(field.getName() + " not found in table's partition spec: " + spec);
        }
        return true;
    }

    public void setProperty(String name, String value) {
        this.getTTable().getParameters().put(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getTTable().getParameters().get(name);
    }

    public Vector<StructField> getFields() {
        Vector<StructField> fields = new Vector<StructField>();
        try {
            Deserializer decoder = this.getDeserializer();
            StructObjectInspector structObjectInspector = (StructObjectInspector)decoder.getObjectInspector();
            List<? extends StructField> fld_lst = structObjectInspector.getAllStructFieldRefs();
            for (StructField structField : fld_lst) {
                fields.add(structField);
            }
        }
        catch (SerDeException e) {
            throw new RuntimeException(e);
        }
        return fields;
    }

    public StructField getField(String fld) {
        try {
            StructObjectInspector structObjectInspector = (StructObjectInspector)this.getDeserializer().getObjectInspector();
            return structObjectInspector.getStructFieldRef(fld);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSchema(Properties schema) {
        this.schema = schema;
    }

    public void setDeserializer(Deserializer deserializer) {
        this.deserializer = deserializer;
    }

    public String toString() {
        return this.getTTable().getTableName();
    }

    public List<FieldSchema> getPartCols() {
        ArrayList partKeys = this.getTTable().getPartitionKeys();
        if (partKeys == null) {
            partKeys = new ArrayList();
            this.getTTable().setPartitionKeys(partKeys);
        }
        return partKeys;
    }

    public boolean isPartitionKey(String colName) {
        for (FieldSchema key : this.getPartCols()) {
            if (!key.getName().toLowerCase().equals(colName)) continue;
            return true;
        }
        return false;
    }

    public String getBucketingDimensionId() {
        List bcols = this.getTTable().getSd().getBucketCols();
        if (bcols == null || bcols.size() == 0) {
            return null;
        }
        if (bcols.size() > 1) {
            LOG.warn((Object)(this + " table has more than one dimensions which aren't supported yet"));
        }
        return (String)bcols.get(0);
    }

    public org.apache.hadoop.hive.metastore.api.Table getTTable() {
        return this.tTable;
    }

    protected void setTTable(org.apache.hadoop.hive.metastore.api.Table table) {
        this.tTable = table;
    }

    public void setDataLocation(URI uri2) {
        this.uri = uri2;
        this.getTTable().getSd().setLocation(uri2.toString());
    }

    public void setBucketCols(List<String> bucketCols) throws HiveException {
        if (bucketCols == null) {
            return;
        }
        for (String col : bucketCols) {
            if (this.isField(col)) continue;
            throw new HiveException("Bucket columns " + col + " is not part of the table columns");
        }
        this.getTTable().getSd().setBucketCols(bucketCols);
    }

    public void setSortCols(List<Order> sortOrder) throws HiveException {
        this.getTTable().getSd().setSortCols(sortOrder);
    }

    private boolean isField(String col) {
        for (FieldSchema field : this.getCols()) {
            if (!field.getName().equals(col)) continue;
            return true;
        }
        return false;
    }

    public List<FieldSchema> getCols() {
        boolean isNative = SerDeUtils.isNativeSerDe(this.getSerializationLib());
        if (isNative) {
            return this.getTTable().getSd().getCols();
        }
        try {
            return Hive.getFieldsFromDeserializer(this.getName(), this.getDeserializer());
        }
        catch (HiveException e) {
            LOG.error((Object)("Unable to get field from serde: " + this.getSerializationLib()), (Throwable)e);
            return new ArrayList<FieldSchema>();
        }
    }

    public List<FieldSchema> getAllCols() {
        ArrayList<FieldSchema> f_list = new ArrayList<FieldSchema>();
        f_list.addAll(this.getPartCols());
        f_list.addAll(this.getCols());
        return f_list;
    }

    public void setPartCols(List<FieldSchema> partCols) {
        this.getTTable().setPartitionKeys(partCols);
    }

    public String getDbName() {
        return this.getTTable().getDbName();
    }

    public int getNumBuckets() {
        return this.getTTable().getSd().getNumBuckets();
    }

    protected void replaceFiles(Path srcf, Path tmpd) throws HiveException {
        try {
            FileSystem fs = FileSystem.get((URI)this.getDataLocation(), (Configuration)Hive.get().getConf());
            Hive.replaceFiles(srcf, new Path(this.getDataLocation().getPath()), fs, tmpd);
        }
        catch (IOException e) {
            throw new HiveException("addFiles: filesystem error in check phase", e);
        }
    }

    protected void copyFiles(Path srcf) throws HiveException {
        try {
            FileSystem fs = FileSystem.get((URI)this.getDataLocation(), (Configuration)Hive.get().getConf());
            Hive.copyFiles(srcf, new Path(this.getDataLocation().getPath()), fs);
        }
        catch (IOException e) {
            throw new HiveException("addFiles: filesystem error in check phase", e);
        }
    }

    public void setInputFormatClass(String name) throws HiveException {
        try {
            this.setInputFormatClass(Class.forName(name, true, JavaUtils.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Class not found: " + name, e);
        }
    }

    public void setOutputFormatClass(String name) throws HiveException {
        try {
            Class<?> origin = Class.forName(name, true, JavaUtils.getClassLoader());
            this.setOutputFormatClass(HiveFileFormatUtils.getOutputFormatSubstitute(origin));
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Class not found: " + name, e);
        }
    }

    public boolean isPartitioned() {
        if (this.getPartCols() == null) {
            return false;
        }
        return this.getPartCols().size() != 0;
    }

    public void setFields(List<FieldSchema> fields) {
        this.getTTable().getSd().setCols(fields);
    }

    public void setNumBuckets(int nb) {
        this.getTTable().getSd().setNumBuckets(nb);
    }

    public String getOwner() {
        return this.tTable.getOwner();
    }

    public Map<String, String> getParameters() {
        return this.tTable.getParameters();
    }

    public int getRetention() {
        return this.tTable.getRetention();
    }

    public void setOwner(String owner) {
        this.tTable.setOwner(owner);
    }

    public void setRetention(int retention) {
        this.tTable.setRetention(retention);
    }

    private SerDeInfo getSerdeInfo() {
        return this.getTTable().getSd().getSerdeInfo();
    }

    public void setSerializationLib(String lib) {
        this.getSerdeInfo().setSerializationLib(lib);
    }

    public String getSerializationLib() {
        return this.getSerdeInfo().getSerializationLib();
    }

    public String getSerdeParam(String param) {
        return (String)this.getSerdeInfo().getParameters().get(param);
    }

    public String setSerdeParam(String param, String value) {
        return this.getSerdeInfo().getParameters().put(param, value);
    }

    public List<String> getBucketCols() {
        return this.getTTable().getSd().getBucketCols();
    }

    public List<Order> getSortCols() {
        return this.getTTable().getSd().getSortCols();
    }

    public LinkedHashMap<String, String> createSpec(Partition tp) {
        List<FieldSchema> fsl = this.getPartCols();
        List tpl = tp.getValues();
        LinkedHashMap<String, String> spec = new LinkedHashMap<String, String>();
        for (int i = 0; i < fsl.size(); ++i) {
            FieldSchema fs = fsl.get(i);
            String value = (String)tpl.get(i);
            spec.put(fs.getName(), value);
        }
        return spec;
    }

    public Table copy() throws HiveException {
        Table newTbl = new Table();
        newTbl.schema = this.schema;
        newTbl.deserializer = this.deserializer;
        newTbl.setTTable(this.getTTable().clone());
        newTbl.uri = this.uri;
        newTbl.inputFormatClass = this.inputFormatClass;
        newTbl.outputFormatClass = this.outputFormatClass;
        return newTbl;
    }
}

