/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.QBMetaData;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.plan.createTableDesc;

public class QB {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.parse.QB");
    private int numJoins = 0;
    private int numGbys = 0;
    private int numSels = 0;
    private int numSelDi = 0;
    private HashMap<String, String> aliasToTabs;
    private HashMap<String, QBExpr> aliasToSubq;
    private QBParseInfo qbp;
    private QBMetaData qbm;
    private QBJoinTree qbjoin;
    private String id;
    private boolean isQuery;
    private createTableDesc tblDesc = null;

    public void print(String msg) {
        LOG.info((Object)(msg + "alias=" + this.qbp.getAlias()));
        for (String alias : this.getSubqAliases()) {
            QBExpr qbexpr = this.getSubqForAlias(alias);
            LOG.info((Object)(msg + "start subquery " + alias));
            qbexpr.print(msg + " ");
            LOG.info((Object)(msg + "end subquery " + alias));
        }
    }

    public QB() {
    }

    public QB(String outer_id, String alias, boolean isSubQ) {
        this.aliasToTabs = new HashMap();
        this.aliasToSubq = new HashMap();
        if (alias != null) {
            alias = alias.toLowerCase();
        }
        this.qbp = new QBParseInfo(alias, isSubQ);
        this.qbm = new QBMetaData();
        this.id = outer_id == null ? alias : outer_id + ":" + alias;
    }

    public QBParseInfo getParseInfo() {
        return this.qbp;
    }

    public QBMetaData getMetaData() {
        return this.qbm;
    }

    public void setQBParseInfo(QBParseInfo qbp) {
        this.qbp = qbp;
    }

    public void countSelDi() {
        ++this.numSelDi;
    }

    public void countSel() {
        ++this.numSels;
    }

    public boolean exists(String alias) {
        return this.aliasToTabs.get(alias = alias.toLowerCase()) != null || this.aliasToSubq.get(alias) != null;
    }

    public void setTabAlias(String alias, String tabName) {
        this.aliasToTabs.put(alias.toLowerCase(), tabName);
    }

    public void setSubqAlias(String alias, QBExpr qbexpr) {
        this.aliasToSubq.put(alias.toLowerCase(), qbexpr);
    }

    public String getId() {
        return this.id;
    }

    public int getNumGbys() {
        return this.numGbys;
    }

    public int getNumSelDi() {
        return this.numSelDi;
    }

    public int getNumSels() {
        return this.numSels;
    }

    public int getNumJoins() {
        return this.numJoins;
    }

    public Set<String> getSubqAliases() {
        return this.aliasToSubq.keySet();
    }

    public Set<String> getTabAliases() {
        return this.aliasToTabs.keySet();
    }

    public QBExpr getSubqForAlias(String alias) {
        return this.aliasToSubq.get(alias.toLowerCase());
    }

    public String getTabNameForAlias(String alias) {
        return this.aliasToTabs.get(alias.toLowerCase());
    }

    public QBJoinTree getQbJoinTree() {
        return this.qbjoin;
    }

    public void setQbJoinTree(QBJoinTree qbjoin) {
        this.qbjoin = qbjoin;
    }

    public void setIsQuery(boolean isQuery) {
        this.isQuery = isQuery;
    }

    public boolean getIsQuery() {
        return this.isQuery;
    }

    public boolean isSelectStarQuery() {
        return this.qbp.isSelectStarQuery() && this.aliasToSubq.isEmpty() && !this.isCTAS();
    }

    public createTableDesc getTableDesc() {
        return this.tblDesc;
    }

    public void setTableDesc(createTableDesc desc) {
        this.tblDesc = desc;
    }

    public boolean isCTAS() {
        return this.tblDesc != null;
    }
}

