/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class QBMetaData {
    public static final int DEST_INVALID = 0;
    public static final int DEST_TABLE = 1;
    public static final int DEST_PARTITION = 2;
    public static final int DEST_DFS_FILE = 3;
    public static final int DEST_REDUCE = 4;
    public static final int DEST_LOCAL_FILE = 5;
    private ArrayList<Class<?>> outTypes = new ArrayList();
    private HashMap<String, Table> aliasToTable = new HashMap();
    private HashMap<String, Table> nameToDestTable = new HashMap();
    private HashMap<String, Partition> nameToDestPartition = new HashMap();
    private HashMap<String, String> nameToDestFile = new HashMap();
    private HashMap<String, Integer> nameToDestType = new HashMap();
    private static final Log LOG = LogFactory.getLog((String)QBMetaData.class.getName());

    public ArrayList<Class<?>> getOutputTypes() {
        return this.outTypes;
    }

    public void addOutputType(Class<?> cls) {
        this.outTypes.add(cls);
    }

    public HashMap<String, Table> getAliasToTable() {
        return this.aliasToTable;
    }

    public Table getTableForAlias(String alias) {
        return this.aliasToTable.get(alias.toLowerCase());
    }

    public void setSrcForAlias(String alias, Table tab) {
        this.aliasToTable.put(alias, tab);
    }

    public void setDestForAlias(String alias, Table tab) {
        this.nameToDestType.put(alias, 1);
        this.nameToDestTable.put(alias, tab);
    }

    public void setDestForAlias(String alias, Partition part) {
        this.nameToDestType.put(alias, 2);
        this.nameToDestPartition.put(alias, part);
    }

    public void setDestForAlias(String alias, String fname, boolean isDfsFile) {
        this.nameToDestType.put(alias, isDfsFile ? Integer.valueOf(3) : Integer.valueOf(5));
        this.nameToDestFile.put(alias, fname);
    }

    public Integer getDestTypeForAlias(String alias) {
        return this.nameToDestType.get(alias.toLowerCase());
    }

    public Table getDestTableForAlias(String alias) {
        return this.nameToDestTable.get(alias.toLowerCase());
    }

    public Partition getDestPartitionForAlias(String alias) {
        return this.nameToDestPartition.get(alias.toLowerCase());
    }

    public String getDestFileForAlias(String alias) {
        return this.nameToDestFile.get(alias.toLowerCase());
    }

    public Table getSrcForAlias(String alias) {
        return this.aliasToTable.get(alias.toLowerCase());
    }
}

