/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class exprNodeGenericFuncDesc
extends exprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private GenericUDF genericUDF;
    private List<exprNodeDesc> childExprs;

    public exprNodeGenericFuncDesc() {
    }

    public exprNodeGenericFuncDesc(TypeInfo typeInfo, GenericUDF genericUDF, List<exprNodeDesc> children) {
        super(typeInfo);
        assert (genericUDF != null);
        this.genericUDF = genericUDF;
        this.childExprs = children;
    }

    public GenericUDF getGenericUDF() {
        return this.genericUDF;
    }

    public void setGenericUDF(GenericUDF genericUDF) {
        this.genericUDF = genericUDF;
    }

    public List<exprNodeDesc> getChildExprs() {
        return this.childExprs;
    }

    public void setChildExprs(List<exprNodeDesc> children) {
        this.childExprs = children;
    }

    @Override
    public List<exprNodeDesc> getChildren() {
        return this.childExprs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genericUDF.getClass().toString());
        sb.append("(");
        for (int i = 0; i < this.childExprs.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.childExprs.get(i).toString());
        }
        sb.append("(");
        sb.append(")");
        return sb.toString();
    }

    @Override
    @explain(displayName="expr")
    public String getExprString() {
        String[] childrenExprStrings = new String[this.childExprs.size()];
        for (int i = 0; i < childrenExprStrings.length; ++i) {
            childrenExprStrings[i] = this.childExprs.get(i).getExprString();
        }
        return this.genericUDF.getDisplayString(childrenExprStrings);
    }

    @Override
    public List<String> getCols() {
        List<String> colList = new ArrayList<String>();
        if (this.childExprs != null) {
            for (int pos = 0; pos < this.childExprs.size(); ++pos) {
                List<String> colCh = this.childExprs.get(pos).getCols();
                colList = Utilities.mergeUniqElems(colList, colCh);
            }
        }
        return colList;
    }

    @Override
    public exprNodeDesc clone() {
        ArrayList<exprNodeDesc> cloneCh = new ArrayList<exprNodeDesc>(this.childExprs.size());
        for (exprNodeDesc ch : this.childExprs) {
            cloneCh.add(ch.clone());
        }
        exprNodeGenericFuncDesc clone = new exprNodeGenericFuncDesc(this.typeInfo, FunctionRegistry.cloneGenericUDF(this.genericUDF), cloneCh);
        return clone;
    }

    public static exprNodeGenericFuncDesc newInstance(GenericUDF genericUDF, List<exprNodeDesc> children) throws UDFArgumentException {
        ObjectInspector[] childrenOIs = new ObjectInspector[children.size()];
        for (int i = 0; i < childrenOIs.length; ++i) {
            childrenOIs[i] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(children.get(i).getTypeInfo());
        }
        ObjectInspector oi = genericUDF.initialize(childrenOIs);
        return new exprNodeGenericFuncDesc(TypeInfoUtils.getTypeInfoFromObjectInspector(oi), genericUDF, children);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof exprNodeGenericFuncDesc)) {
            return false;
        }
        exprNodeGenericFuncDesc dest = (exprNodeGenericFuncDesc)o;
        if (!this.typeInfo.equals(dest.getTypeInfo()) || !this.genericUDF.getClass().equals(dest.getGenericUDF().getClass())) {
            return false;
        }
        if (this.genericUDF instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)this.genericUDF;
            GenericUDFBridge bridge2 = (GenericUDFBridge)dest.getGenericUDF();
            if (!bridge.getUdfClass().equals(bridge2.getUdfClass()) || !bridge.getUdfName().equals(bridge2.getUdfName()) || bridge.isOperator() != bridge2.isOperator()) {
                return false;
            }
        }
        if (this.childExprs.size() != dest.getChildExprs().size()) {
            return false;
        }
        for (int pos = 0; pos < this.childExprs.size(); ++pos) {
            if (this.childExprs.get(pos).isSame(dest.getChildExprs().get(pos))) continue;
            return false;
        }
        return true;
    }
}

