/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;

@explain(displayName="Partition")
public class partitionDesc
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    private tableDesc table;
    private LinkedHashMap<String, String> partSpec;
    private Class<? extends Deserializer> deserializerClass;
    private Class<? extends InputFormat> inputFileFormatClass;
    private Class<? extends HiveOutputFormat> outputFileFormatClass;
    private Properties properties;
    private String serdeClassName;
    private transient String baseFileName;

    public partitionDesc() {
    }

    public partitionDesc(tableDesc table, LinkedHashMap<String, String> partSpec) {
        this(table, partSpec, null, null, null, null, null);
    }

    public partitionDesc(tableDesc table, LinkedHashMap<String, String> partSpec, Class<? extends Deserializer> serdeClass, Class<? extends InputFormat> inputFileFormatClass, Class<?> outputFormat, Properties properties, String serdeClassName) {
        this.table = table;
        this.partSpec = partSpec;
        this.deserializerClass = serdeClass;
        this.inputFileFormatClass = inputFileFormatClass;
        if (outputFormat != null) {
            this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFormat);
        }
        this.properties = properties;
        if (properties != null) {
            this.serdeClassName = properties.getProperty("serialization.lib");
        }
    }

    public partitionDesc(Partition part) throws HiveException {
        this.table = Utilities.getTableDesc(part.getTable());
        this.partSpec = part.getSpec();
        this.deserializerClass = part.getDeserializer().getClass();
        this.inputFileFormatClass = part.getInputFormatClass();
        this.outputFileFormatClass = part.getOutputFormatClass();
        this.properties = part.getSchema();
        this.serdeClassName = this.properties.getProperty("serialization.lib");
    }

    @explain(displayName="")
    public tableDesc getTableDesc() {
        return this.table;
    }

    public void setTableDesc(tableDesc table) {
        this.table = table;
    }

    @explain(displayName="partition values")
    public LinkedHashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpec(LinkedHashMap<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    public Class<? extends Deserializer> getDeserializerClass() {
        if (this.deserializerClass == null && this.table != null) {
            this.setDeserializerClass(this.table.getDeserializerClass());
        }
        return this.deserializerClass;
    }

    public void setDeserializerClass(Class<? extends Deserializer> serdeClass) {
        this.deserializerClass = serdeClass;
    }

    public Class<? extends InputFormat> getInputFileFormatClass() {
        if (this.inputFileFormatClass == null && this.table != null) {
            this.setInputFileFormatClass(this.table.getInputFileFormatClass());
        }
        return this.inputFileFormatClass;
    }

    public Deserializer getDeserializer() throws Exception {
        Deserializer de = this.deserializerClass.newInstance();
        de.initialize(null, this.properties);
        return de;
    }

    public void setInputFileFormatClass(Class<? extends InputFormat> inputFileFormatClass) {
        this.inputFileFormatClass = inputFileFormatClass;
    }

    public Class<? extends HiveOutputFormat> getOutputFileFormatClass() {
        if (this.outputFileFormatClass == null && this.table != null) {
            this.setOutputFileFormatClass(this.table.getOutputFileFormatClass());
        }
        return this.outputFileFormatClass;
    }

    public void setOutputFileFormatClass(Class<?> outputFileFormatClass) {
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFileFormatClass);
    }

    @explain(displayName="properties", normalExplain=false)
    public Properties getProperties() {
        if (this.table != null) {
            return this.table.getProperties();
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @explain(displayName="serde")
    public String getSerdeClassName() {
        if (this.serdeClassName == null && this.table != null) {
            this.setSerdeClassName(this.table.getSerdeClassName());
        }
        return this.serdeClassName;
    }

    public void setSerdeClassName(String serdeClassName) {
        this.serdeClassName = serdeClassName;
    }

    @explain(displayName="name")
    public String getTableName() {
        return this.getProperties().getProperty("name");
    }

    @explain(displayName="input format")
    public String getInputFileFormatClassName() {
        return this.getInputFileFormatClass().getName();
    }

    @explain(displayName="output format")
    public String getOutputFileFormatClassName() {
        return this.getOutputFileFormatClass().getName();
    }

    @explain(displayName="base file name", normalExplain=false)
    public String getBaseFileName() {
        return this.baseFileName;
    }

    public partitionDesc clone() {
        partitionDesc ret = new partitionDesc();
        ret.setSerdeClassName(this.serdeClassName);
        ret.setDeserializerClass(this.deserializerClass);
        ret.inputFileFormatClass = this.inputFileFormatClass;
        ret.outputFileFormatClass = this.outputFileFormatClass;
        if (this.properties != null) {
            Properties newProp = new Properties();
            Enumeration<Object> keysProp = this.properties.keys();
            while (keysProp.hasMoreElements()) {
                Object key = keysProp.nextElement();
                newProp.put(key, this.properties.get(key));
            }
            ret.setProperties(newProp);
        }
        ret.table = (tableDesc)this.table.clone();
        if (this.partSpec != null) {
            ret.partSpec = new LinkedHashMap();
            ret.partSpec.putAll(this.partSpec);
        }
        return ret;
    }

    void deriveBaseFileName(String path) {
        if (path == null) {
            return;
        }
        try {
            URI uri = new URI(path);
            File file = new File(uri);
            this.baseFileName = file.getName();
        }
        catch (Exception ex) {
            this.baseFileName = path;
        }
    }
}

