/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.ppd.OpProcFactory;

public class ExprWalkerInfo
implements NodeProcessorCtx {
    protected static final Log LOG = LogFactory.getLog((String)OpProcFactory.class.getName());
    private Operator<? extends Serializable> op = null;
    private RowResolver toRR = null;
    private Map<String, List<exprNodeDesc>> pushdownPreds;
    private Map<exprNodeDesc, ExprInfo> exprInfoMap;
    private boolean isDeterministic = true;

    public ExprWalkerInfo() {
        this.pushdownPreds = new HashMap<String, List<exprNodeDesc>>();
        this.exprInfoMap = new HashMap<exprNodeDesc, ExprInfo>();
    }

    public ExprWalkerInfo(Operator<? extends Serializable> op, RowResolver toRR) {
        this.op = op;
        this.toRR = toRR;
        this.pushdownPreds = new HashMap<String, List<exprNodeDesc>>();
        this.exprInfoMap = new HashMap<exprNodeDesc, ExprInfo>();
    }

    public Operator<? extends Serializable> getOp() {
        return this.op;
    }

    public RowResolver getToRR() {
        return this.toRR;
    }

    public exprNodeDesc getConvertedNode(Node nd) {
        ExprInfo ei = this.exprInfoMap.get(nd);
        if (ei == null) {
            return null;
        }
        return ei.convertedExpr;
    }

    public void addConvertedNode(exprNodeDesc oldNode, exprNodeDesc newNode) {
        ExprInfo ei = this.exprInfoMap.get(oldNode);
        if (ei == null) {
            ei = new ExprInfo();
            this.exprInfoMap.put(oldNode, ei);
        }
        ei.convertedExpr = newNode;
        this.exprInfoMap.put(newNode, new ExprInfo(ei.isCandidate, ei.alias, null));
    }

    public boolean isCandidate(exprNodeDesc expr) {
        ExprInfo ei = this.exprInfoMap.get(expr);
        if (ei == null) {
            return false;
        }
        return ei.isCandidate;
    }

    public void setIsCandidate(exprNodeDesc expr, boolean b) {
        ExprInfo ei = this.exprInfoMap.get(expr);
        if (ei == null) {
            ei = new ExprInfo();
            this.exprInfoMap.put(expr, ei);
        }
        ei.isCandidate = b;
    }

    public String getAlias(exprNodeDesc expr) {
        ExprInfo ei = this.exprInfoMap.get(expr);
        if (ei == null) {
            return null;
        }
        return ei.alias;
    }

    public void addAlias(exprNodeDesc expr, String alias) {
        if (alias == null) {
            return;
        }
        ExprInfo ei = this.exprInfoMap.get(expr);
        if (ei == null) {
            ei = new ExprInfo();
            this.exprInfoMap.put(expr, ei);
        }
        ei.alias = alias;
    }

    public void addFinalCandidate(exprNodeDesc expr) {
        String alias = this.getAlias(expr);
        if (this.pushdownPreds.get(alias) == null) {
            this.pushdownPreds.put(alias, new ArrayList());
        }
        this.pushdownPreds.get(alias).add(expr.clone());
    }

    public Map<String, List<exprNodeDesc>> getFinalCandidates() {
        return this.pushdownPreds;
    }

    public void merge(ExprWalkerInfo ewi) {
        if (ewi == null) {
            return;
        }
        for (Map.Entry<String, List<exprNodeDesc>> e : ewi.getFinalCandidates().entrySet()) {
            List<exprNodeDesc> predList = this.pushdownPreds.get(e.getKey());
            if (predList != null) {
                predList.addAll((Collection<exprNodeDesc>)e.getValue());
                continue;
            }
            this.pushdownPreds.put(e.getKey(), e.getValue());
        }
    }

    public void setDeterministic(boolean b) {
        this.isDeterministic = b;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    private static class ExprInfo {
        public boolean isCandidate = false;
        public String alias = null;
        public exprNodeDesc convertedExpr = null;

        public ExprInfo() {
        }

        public ExprInfo(boolean isCandidate, String alias, exprNodeDesc replacedNode) {
            this.isCandidate = isCandidate;
            this.alias = alias;
            this.convertedExpr = replacedNode;
        }
    }
}

