/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.filterDesc;
import org.apache.hadoop.hive.ql.plan.joinCond;
import org.apache.hadoop.hive.ql.plan.joinDesc;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerInfo;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerProcFactory;
import org.apache.hadoop.hive.ql.ppd.OpWalkerInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class OpProcFactory {
    protected static Object createFilter(Operator op, ExprWalkerInfo pushDownPreds, OpWalkerInfo owi) {
        if (pushDownPreds == null || pushDownPreds.getFinalCandidates() == null || pushDownPreds.getFinalCandidates().size() == 0) {
            return null;
        }
        RowResolver inputRR = owi.getRowResolver(op);
        List<exprNodeDesc> preds2 = null;
        exprNodeDesc condn = null;
        for (List<exprNodeDesc> preds2 : pushDownPreds.getFinalCandidates().values()) {
            int i = 0;
            if (condn == null) {
                condn = preds2.get(0);
                ++i;
            }
            while (i < preds2.size()) {
                ArrayList<exprNodeDesc> children = new ArrayList<exprNodeDesc>(2);
                children.add(condn);
                children.add(preds2.get(i));
                condn = new exprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
                ++i;
            }
        }
        if (condn == null) {
            return null;
        }
        List<Operator<? extends Serializable>> originalChilren = op.getChildOperators();
        op.setChildOperators(null);
        Operator<filterDesc> output = OperatorFactory.getAndMakeChild(new filterDesc(condn, false), new RowSchema(inputRR.getColumnInfos()), op);
        output.setChildOperators(originalChilren);
        for (Operator<? extends Serializable> ch : originalChilren) {
            List<Operator<Serializable>> parentOperators = ch.getParentOperators();
            int pos = parentOperators.indexOf(op);
            assert (pos != -1);
            parentOperators.remove(pos);
            parentOperators.add(pos, output);
        }
        OpParseContext ctx = new OpParseContext(inputRR);
        owi.put(output, ctx);
        return output;
    }

    public static NodeProcessor getFilterProc() {
        return new FilterPPD();
    }

    public static NodeProcessor getJoinProc() {
        return new JoinPPD();
    }

    public static NodeProcessor getRSProc() {
        return new ReduceSinkPPD();
    }

    public static NodeProcessor getTSProc() {
        return new TableScanPPD();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultPPD();
    }

    public static NodeProcessor getSCRProc() {
        return new ScriptPPD();
    }

    public static NodeProcessor getLIMProc() {
        return new ScriptPPD();
    }

    public static class DefaultPPD
    implements NodeProcessor {
        protected static final Log LOG = LogFactory.getLog((String)OpProcFactory.class.getName());

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            this.mergeWithChildrenPred(nd, (OpWalkerInfo)procCtx, null, null, false);
            return null;
        }

        protected void logExpr(Node nd, ExprWalkerInfo ewi) {
            for (Map.Entry<String, List<exprNodeDesc>> e : ewi.getFinalCandidates().entrySet()) {
                LOG.info((Object)("Pushdown Predicates of " + nd.getName() + " For Alias : " + e.getKey()));
                for (exprNodeDesc n : e.getValue()) {
                    LOG.info((Object)("\t" + n.getExprString()));
                }
            }
        }

        protected void mergeWithChildrenPred(Node nd, OpWalkerInfo owi, ExprWalkerInfo ewi, Set<String> aliases, boolean ignoreAliases) throws SemanticException {
            if (nd.getChildren() == null || nd.getChildren().size() > 1) {
                return;
            }
            Operator op = (Operator)nd;
            ExprWalkerInfo childPreds = owi.getPrunedPreds((Operator)nd.getChildren().get(0));
            if (childPreds == null) {
                return;
            }
            if (ewi == null) {
                ewi = new ExprWalkerInfo();
            }
            for (Map.Entry<String, List<exprNodeDesc>> e : childPreds.getFinalCandidates().entrySet()) {
                if (!ignoreAliases && aliases != null && !aliases.contains(e.getKey()) && e.getKey() != null) continue;
                ExprWalkerInfo extractPushdownPreds = ExprWalkerProcFactory.extractPushdownPreds(owi, (Operator<? extends Serializable>)op, e.getValue());
                ewi.merge(extractPushdownPreds);
                this.logExpr(nd, extractPushdownPreds);
            }
            owi.putPrunedPreds((Operator)nd, ewi);
        }
    }

    public static class ReduceSinkPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Set<String> aliases = owi.getRowResolver(nd).getTableNames();
            boolean ignoreAliases = false;
            if (aliases.size() == 1 && aliases.contains("")) {
                ignoreAliases = true;
            }
            this.mergeWithChildrenPred(nd, owi, null, aliases, ignoreAliases);
            return null;
        }
    }

    public static class JoinPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Set<String> aliases = this.getQualifiedAliases((JoinOperator)nd, owi.getRowResolver(nd));
            this.mergeWithChildrenPred(nd, owi, null, aliases, false);
            return null;
        }

        private Set<String> getQualifiedAliases(JoinOperator op, RowResolver rr) {
            HashSet<String> aliases = new HashSet<String>();
            int loj = Integer.MAX_VALUE;
            int roj = -1;
            boolean oj = false;
            joinCond[] conds = ((joinDesc)op.getConf()).getConds();
            Map<Integer, Set<String>> posToAliasMap = op.getPosToAliasMap();
            for (joinCond jc : conds) {
                if (jc.getType() == 3) {
                    oj = true;
                    break;
                }
                if (jc.getType() == 1) {
                    if (jc.getLeft() >= loj) continue;
                    loj = jc.getLeft();
                    continue;
                }
                if (jc.getType() != 2 || jc.getRight() <= roj) continue;
                roj = jc.getRight();
            }
            if (oj || loj != Integer.MAX_VALUE && roj != -1) {
                return aliases;
            }
            for (Map.Entry<Integer, Set<String>> pa : posToAliasMap.entrySet()) {
                if (loj != Integer.MAX_VALUE) {
                    if (pa.getKey() > loj) continue;
                    aliases.addAll((Collection<String>)pa.getValue());
                    continue;
                }
                if (roj != -1) {
                    if (pa.getKey() < roj) continue;
                    aliases.addAll((Collection<String>)pa.getValue());
                    continue;
                }
                aliases.addAll((Collection<String>)pa.getValue());
            }
            Set<String> aliases2 = rr.getTableNames();
            aliases.retainAll(aliases2);
            return aliases;
        }
    }

    public static class FilterPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Operator op = (Operator)nd;
            exprNodeDesc predicate = ((filterDesc)((FilterOperator)nd).getConf()).getPredicate();
            ExprWalkerInfo ewi = ExprWalkerProcFactory.extractPushdownPreds(owi, (Operator<? extends Serializable>)op, predicate);
            if (!ewi.isDeterministic()) {
                if (op.getChildren() != null && ((Vector)op.getChildren()).size() == 1) {
                    OpProcFactory.createFilter(op, owi.getPrunedPreds((Operator)((Vector)op.getChildren()).get(0)), owi);
                }
                return null;
            }
            this.logExpr(nd, ewi);
            owi.putPrunedPreds(op, ewi);
            this.mergeWithChildrenPred(op, owi, ewi, null, false);
            return null;
        }
    }

    public static class TableScanPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            TableScanOperator tsOp = (TableScanOperator)nd;
            this.mergeWithChildrenPred(tsOp, owi, null, null, false);
            ExprWalkerInfo pushDownPreds = owi.getPrunedPreds(tsOp);
            return OpProcFactory.createFilter(tsOp, pushDownPreds, owi);
        }
    }

    public static class ScriptPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            return null;
        }
    }
}

