/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@description(name="datediff", value="_FUNC_(date1, date2) - Returns the number of days between date1 and date2", extended="date1 and date2 are strings in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. The time parts are ignored.If date1 is earlier than date2, the result is negative.\nExample:\n   > SELECT _FUNC_('2009-30-07', '2009-31-07') FROM src LIMIT 1;\n  1")
public class UDFDateDiff
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFDateDiff.class.getName());
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    IntWritable result = new IntWritable();

    public UDFDateDiff() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public IntWritable evaluate(Text dateString1, Text dateString2) {
        if (dateString1 == null || dateString2 == null) {
            return null;
        }
        try {
            long diffInMilliSeconds = this.formatter.parse(dateString1.toString()).getTime() - this.formatter.parse(dateString2.toString()).getTime();
            this.result.set((int)(diffInMilliSeconds / 86400000L));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

