/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@description(name="sqrt", value="_FUNC_(x) - returns the square root of x", extended="Example:\n   > SELECT _FUNC_(4) FROM src LIMIT 1;\n  2")
public class UDFSqrt
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFSqrt.class.getName());
    DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        if (i.get() < 0.0) {
            return null;
        }
        this.result.set(Math.sqrt(i.get()));
        return this.result;
    }
}

