/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@description(name="yearweek", value="_FUNC_(date) - Returns the week of the year of the given date. A week is considered to start on a Monday and week 1 is the first week with >3 days.", extended="Examples:\n  > SELECT _FUNC_('2008-02-20') FROM src LIMIT 1;\n  8\n  > SELECT _FUNC_('1980-12-31 12:59:59') FROM src LIMIT 1;\n  1")
public class UDFWeekOfYear
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFWeekOfYear.class.getName());
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private Calendar calendar = Calendar.getInstance();
    IntWritable result = new IntWritable();

    public UDFWeekOfYear() {
        this.calendar.setFirstDayOfWeek(2);
        this.calendar.setMinimalDaysInFirstWeek(4);
    }

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateString.toString());
            this.calendar.setTime(date);
            this.result.set(this.calendar.get(3));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

