/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;

public class GenericUDFIf
extends GenericUDF {
    ObjectInspector[] argumentOIs;
    GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        boolean conditionTypeIsOk;
        this.argumentOIs = arguments;
        this.returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        if (arguments.length != 3) {
            throw new UDFArgumentLengthException("The function IF(expr1,expr2,expr3) accepts exactly 3 arguments.");
        }
        boolean bl = conditionTypeIsOk = arguments[0].getCategory() == ObjectInspector.Category.PRIMITIVE;
        if (conditionTypeIsOk) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)arguments[0];
            boolean bl2 = conditionTypeIsOk = poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN || poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.VOID;
        }
        if (!conditionTypeIsOk) {
            throw new UDFArgumentTypeException(0, "The first argument of function IF should be \"boolean\", but \"" + arguments[0].getTypeName() + "\" is found");
        }
        if (!this.returnOIResolver.update(arguments[1]) || !this.returnOIResolver.update(arguments[2])) {
            throw new UDFArgumentTypeException(2, "The second and the third arguments of function IF should have the same type, but they are different: \"" + arguments[1].getTypeName() + "\" and \"" + arguments[2].getTypeName() + "\"");
        }
        return this.returnOIResolver.get();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object condition = arguments[0].get();
        if (condition != null && ((BooleanObjectInspector)this.argumentOIs[0]).get(condition)) {
            return this.returnOIResolver.convertIfNecessary(arguments[1].get(), this.argumentOIs[1]);
        }
        return this.returnOIResolver.convertIfNecessary(arguments[2].get(), this.argumentOIs[2]);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 3);
        StringBuilder sb = new StringBuilder();
        sb.append("if(");
        sb.append(children[0]).append(", ");
        sb.append(children[1]).append(", ");
        sb.append(children[2]).append(")");
        return sb.toString();
    }
}

