/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransportException;

public class TSocket
extends TIOStreamTransport {
    private static final Logger LOGGER = Logger.getLogger((String)TSocket.class.getName());
    private Socket socket_ = null;
    private String host_ = null;
    private int port_ = 0;
    private int timeout_ = 0;

    public TSocket(Socket socket) throws TTransportException {
        this.socket_ = socket;
        try {
            this.socket_.setSoLinger(false, 0);
            this.socket_.setTcpNoDelay(true);
        }
        catch (SocketException sx) {
            LOGGER.warn((Object)"Could not configure socket.", (Throwable)sx);
        }
        if (this.isOpen()) {
            try {
                this.inputStream_ = new BufferedInputStream(this.socket_.getInputStream(), 1024);
                this.outputStream_ = new BufferedOutputStream(this.socket_.getOutputStream(), 1024);
            }
            catch (IOException iox) {
                this.close();
                throw new TTransportException(1, (Throwable)iox);
            }
        }
    }

    public TSocket(String host, int port) {
        this(host, port, 0);
    }

    public TSocket(String host, int port, int timeout) {
        this.host_ = host;
        this.port_ = port;
        this.timeout_ = timeout;
        this.initSocket();
    }

    private void initSocket() {
        this.socket_ = new Socket();
        try {
            this.socket_.setSoLinger(false, 0);
            this.socket_.setTcpNoDelay(true);
            this.socket_.setSoTimeout(this.timeout_);
        }
        catch (SocketException sx) {
            LOGGER.error((Object)"Could not configure socket.", (Throwable)sx);
        }
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
        try {
            this.socket_.setSoTimeout(timeout);
        }
        catch (SocketException sx) {
            LOGGER.warn((Object)"Could not set socket timeout.", (Throwable)sx);
        }
    }

    public Socket getSocket() {
        if (this.socket_ == null) {
            this.initSocket();
        }
        return this.socket_;
    }

    public boolean isOpen() {
        if (this.socket_ == null) {
            return false;
        }
        return this.socket_.isConnected();
    }

    public void open() throws TTransportException {
        if (this.isOpen()) {
            throw new TTransportException(2, "Socket already connected.");
        }
        if (this.host_.length() == 0) {
            throw new TTransportException(1, "Cannot open null host.");
        }
        if (this.port_ <= 0) {
            throw new TTransportException(1, "Cannot open without port.");
        }
        if (this.socket_ == null) {
            this.initSocket();
        }
        try {
            this.socket_.connect(new InetSocketAddress(this.host_, this.port_));
            this.inputStream_ = new BufferedInputStream(this.socket_.getInputStream(), 1024);
            this.outputStream_ = new BufferedOutputStream(this.socket_.getOutputStream(), 1024);
        }
        catch (IOException iox) {
            this.close();
            throw new TTransportException(1, (Throwable)iox);
        }
    }

    public void close() {
        super.close();
        if (this.socket_ != null) {
            try {
                this.socket_.close();
            }
            catch (IOException iox) {
                LOGGER.warn((Object)"Could not close socket.", (Throwable)iox);
            }
            this.socket_ = null;
        }
    }
}

