/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import org.apache.hadoop.examples.AggregateWordCount;
import org.apache.hadoop.examples.AggregateWordHistogram;
import org.apache.hadoop.examples.DBCountPageView;
import org.apache.hadoop.examples.Grep;
import org.apache.hadoop.examples.Join;
import org.apache.hadoop.examples.MultiFileWordCount;
import org.apache.hadoop.examples.PiEstimator;
import org.apache.hadoop.examples.RandomTextWriter;
import org.apache.hadoop.examples.RandomWriter;
import org.apache.hadoop.examples.SecondarySort;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.examples.Sort;
import org.apache.hadoop.examples.WordCount;
import org.apache.hadoop.examples.dancing.DistributedPentomino;
import org.apache.hadoop.examples.dancing.Sudoku;
import org.apache.hadoop.examples.terasort.TeraGen;
import org.apache.hadoop.examples.terasort.TeraSort;
import org.apache.hadoop.examples.terasort.TeraValidate;
import org.apache.hadoop.util.ProgramDriver;

public class ExampleDriver {
    public static void main(String[] argv) {
        int exitCode = -1;
        ProgramDriver pgd = new ProgramDriver();
        try {
            pgd.addClass("wordcount", WordCount.class, "A map/reduce program that counts the words in the input files.");
            pgd.addClass("aggregatewordcount", AggregateWordCount.class, "An Aggregate based map/reduce program that counts the words in the input files.");
            pgd.addClass("aggregatewordhist", AggregateWordHistogram.class, "An Aggregate based map/reduce program that computes the histogram of the words in the input files.");
            pgd.addClass("grep", Grep.class, "A map/reduce program that counts the matches of a regex in the input.");
            pgd.addClass("randomwriter", RandomWriter.class, "A map/reduce program that writes 10GB of random data per node.");
            pgd.addClass("randomtextwriter", RandomTextWriter.class, "A map/reduce program that writes 10GB of random textual data per node.");
            pgd.addClass("sort", Sort.class, "A map/reduce program that sorts the data written by the random writer.");
            pgd.addClass("pi", PiEstimator.class, "A map/reduce program that estimates Pi using monte-carlo method.");
            pgd.addClass("pentomino", DistributedPentomino.class, "A map/reduce tile laying program to find solutions to pentomino problems.");
            pgd.addClass("secondarysort", SecondarySort.class, "An example defining a secondary sort to the reduce.");
            pgd.addClass("sudoku", Sudoku.class, "A sudoku solver.");
            pgd.addClass("sleep", SleepJob.class, "A job that sleeps at each map and reduce task.");
            pgd.addClass("join", Join.class, "A job that effects a join over sorted, equally partitioned datasets");
            pgd.addClass("multifilewc", MultiFileWordCount.class, "A job that counts words from several files.");
            pgd.addClass("dbcount", DBCountPageView.class, "An example job that count the pageview counts from a database.");
            pgd.addClass("teragen", TeraGen.class, "Generate data for the terasort");
            pgd.addClass("terasort", TeraSort.class, "Run the terasort");
            pgd.addClass("teravalidate", TeraValidate.class, "Checking results of terasort");
            pgd.driver(argv);
            exitCode = 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(exitCode);
    }
}

