/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Iterators {
    private Iterators() {
    }

    public static Filter dupFilter() {
        return new Filter(){
            final Set seen = new HashSet();

            public Iterator filter(final Iterator in) {
                return new Iterator(){
                    boolean fresh = false;
                    Object peek;

                    public boolean hasNext() {
                        if (this.fresh) {
                            return true;
                        }
                        while (in.hasNext()) {
                            this.peek = in.next();
                            if (!seen.contains(this.peek)) {
                                this.fresh = true;
                                return true;
                            }
                            this.peek = null;
                        }
                        return false;
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object ret = this.peek;
                        this.peek = null;
                        this.fresh = false;
                        return ret;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterator array(final Object[] o) {
        return new Iterator(){
            int i = 0;
            int len = o == null ? 0 : o.length;

            public boolean hasNext() {
                return this.i < this.len;
            }

            public Object next() {
                if (this.i < this.len) {
                    return o[this.i++];
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator mapOver(final Iterator a, final Getter g) {
        return new Iterator(){
            Iterator delegate = new Iterator(){

                public boolean hasNext() {
                    if (!a.hasNext()) {
                        return false;
                    }
                    Object o = a.next();
                    delegate = Iterators.append1(g.get(o), this);
                    return delegate.hasNext();
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new UnsupportedOperationException();
                    }
                    return delegate.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public Object next() {
                return this.delegate.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator recur(final Object a, final Getter g) {
        return new Iterator(){
            Iterator delegate;
            {
                this.delegate = Iterators.one(a);
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public Object next() {
                Object next = this.delegate.next();
                this.delegate = Iterators.append(g.get(next), this.delegate);
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator append(Iterator a, Iterator b) {
        if (!b.hasNext()) {
            return a;
        }
        return Iterators.append1(a, b);
    }

    public static Iterator append1(final Iterator a, final Iterator b) {
        if (!a.hasNext()) {
            return b;
        }
        return new Iterator(){

            public boolean hasNext() {
                return a.hasNext() || b.hasNext();
            }

            public Object next() {
                if (a.hasNext()) {
                    return a.next();
                }
                if (b.hasNext()) {
                    return b.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator snoc(final Iterator first, final Object last) {
        return new Iterator(){
            Object last1;
            {
                this.last1 = last;
            }

            public boolean hasNext() {
                return first.hasNext() || this.last1 != null;
            }

            public Object next() {
                if (first.hasNext()) {
                    return first.next();
                }
                if (this.last1 == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.last1;
                this.last1 = null;
                return ret;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator one(final Object it) {
        return new Iterator(){
            boolean avail = true;

            public boolean hasNext() {
                return this.avail;
            }

            public Object next() {
                if (!this.avail) {
                    throw new NoSuchElementException();
                }
                this.avail = false;
                return it;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static interface Filter {
        public Iterator filter(Iterator var1);
    }

    public static interface Getter {
        public Iterator get(Object var1);
    }
}

