/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;

@explain(displayName="Fetch Operator")
public class fetchWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String tblDir;
    private tableDesc tblDesc;
    private List<String> partDir;
    private List<partitionDesc> partDesc;
    private int limit;
    private String serializationNullFormat = "NULL";

    public fetchWork() {
    }

    public fetchWork(String tblDir, tableDesc tblDesc) {
        this(tblDir, tblDesc, -1);
    }

    public fetchWork(String tblDir, tableDesc tblDesc, int limit) {
        this.tblDir = tblDir;
        this.tblDesc = tblDesc;
        this.limit = limit;
    }

    public fetchWork(List<String> partDir, List<partitionDesc> partDesc) {
        this(partDir, partDesc, -1);
    }

    public fetchWork(List<String> partDir, List<partitionDesc> partDesc, int limit) {
        this.partDir = partDir;
        this.partDesc = partDesc;
        this.limit = limit;
    }

    public String getSerializationNullFormat() {
        return this.serializationNullFormat;
    }

    public void setSerializationNullFormat(String format) {
        this.serializationNullFormat = format;
    }

    public String getTblDir() {
        return this.tblDir;
    }

    public Path getTblDirPath() {
        return new Path(this.tblDir);
    }

    public void setTblDir(String tblDir) {
        this.tblDir = tblDir;
    }

    public tableDesc getTblDesc() {
        return this.tblDesc;
    }

    public void setTblDesc(tableDesc tblDesc) {
        this.tblDesc = tblDesc;
    }

    public List<String> getPartDir() {
        return this.partDir;
    }

    public List<Path> getPartDirPath() {
        return fetchWork.convertStringToPathArray(this.partDir);
    }

    public static List<String> convertPathToStringArray(List<Path> paths) {
        if (paths == null) {
            return null;
        }
        ArrayList<String> pathsStr = new ArrayList<String>();
        for (Path path : paths) {
            pathsStr.add(path.toString());
        }
        return pathsStr;
    }

    public static List<Path> convertStringToPathArray(List<String> paths) {
        if (paths == null) {
            return null;
        }
        ArrayList<Path> pathsStr = new ArrayList<Path>();
        for (String path : paths) {
            pathsStr.add(new Path(path));
        }
        return pathsStr;
    }

    public void setPartDir(List<String> partDir) {
        this.partDir = partDir;
    }

    public List<partitionDesc> getPartDesc() {
        return this.partDesc;
    }

    public void setPartDesc(List<partitionDesc> partDesc) {
        this.partDesc = partDesc;
    }

    @explain(displayName="limit")
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String toString() {
        if (this.tblDir != null) {
            return new String("table = " + this.tblDir);
        }
        if (this.partDir == null) {
            return "null fetchwork";
        }
        String ret = new String("partition = ");
        for (String part : this.partDir) {
            ret = ret.concat(part);
        }
        return ret;
    }
}

