/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@description(name="month", value="_FUNC_(date) - Returns the month of date", extended="Example:\n  > SELECT _FUNC_('2009-30-07') FROM src LIMIT 1;\n  7")
public class UDFMonth
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFMonth.class.getName());
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private Calendar calendar = Calendar.getInstance();
    IntWritable result = new IntWritable();

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateString.toString());
            this.calendar.setTime(date);
            this.result.set(1 + this.calendar.get(2));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

