/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class IntLiteral
extends NumberLiteral {
    public int value;
    public static final IntLiteral One = new IntLiteral(new char[]{'1'}, 0, 0, 1);
    static final Constant FORMAT_ERROR = DoubleConstant.fromValue(Double.POSITIVE_INFINITY);

    public IntLiteral(char[] token, int s, int e) {
        super(token, s, e);
    }

    public IntLiteral(char[] token, int s, int e, int value) {
        this(token, s, e);
        this.value = value;
    }

    public IntLiteral(int intValue) {
        super(null, 0, 0);
        this.constant = IntConstant.fromValue(intValue);
        this.value = intValue;
    }

    public void computeConstant() {
        long MAX = Integer.MAX_VALUE;
        if (this == One) {
            this.constant = IntConstant.fromValue(1);
            return;
        }
        int length = this.source.length;
        long computedValue = 0L;
        if (this.source[0] == '0') {
            int radix;
            int j;
            int shift;
            MAX = 0xFFFFFFFFL;
            if (length == 1) {
                this.constant = IntConstant.fromValue(0);
                return;
            }
            if (this.source[1] == 'x' || this.source[1] == 'X') {
                shift = 4;
                j = 2;
                radix = 16;
            } else {
                shift = 3;
                j = 1;
                radix = 8;
            }
            while (this.source[j] == '0') {
                if (++j != length) continue;
                this.value = (int)computedValue;
                this.constant = IntConstant.fromValue(this.value);
                return;
            }
            while (j < length) {
                int digitValue;
                if ((digitValue = ScannerHelper.digit(this.source[j++], radix)) < 0) {
                    this.constant = FORMAT_ERROR;
                    return;
                }
                if ((computedValue = computedValue << shift | (long)digitValue) <= MAX) continue;
                return;
            }
        } else {
            int i = 0;
            while (i < length) {
                int digitValue = ScannerHelper.digit(this.source[i], 10);
                if (digitValue < 0) {
                    this.constant = FORMAT_ERROR;
                    return;
                }
                if ((computedValue = 10L * computedValue + (long)digitValue) > MAX) {
                    return;
                }
                ++i;
            }
        }
        this.value = (int)computedValue;
        this.constant = IntConstant.fromValue(this.value);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope scope) {
        return TypeBinding.INT;
    }

    public final boolean mayRepresentMIN_VALUE() {
        return this.source.length == 10 && this.source[0] == '2' && this.source[1] == '1' && this.source[2] == '4' && this.source[3] == '7' && this.source[4] == '4' && this.source[5] == '8' && this.source[6] == '3' && this.source[7] == '6' && this.source[8] == '4' && this.source[9] == '8' && (this.bits & 0x1FE00000) >> 21 == 0;
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding tb = super.resolveType(scope);
        if (this.constant == FORMAT_ERROR) {
            this.constant = Constant.NotAConstant;
            scope.problemReporter().constantOutOfFormat(this);
            this.resolvedType = null;
            return null;
        }
        return tb;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.source == null) {
            return output.append(String.valueOf(this.value));
        }
        return super.printExpression(indent, output);
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

