/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.identity.SingleFieldPK;

public class ShortFieldPK
extends SingleFieldPK {
    private short key;

    public ShortFieldPK(Class pcClass, short key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public ShortFieldPK(Class pcClass, Short key) {
        super(pcClass);
        this.setKeyAsObject(key);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public ShortFieldPK(Class pcClass, String str) {
        super(pcClass);
        this.assertKeyNotNull(str);
        this.key = Short.parseShort(str);
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public ShortFieldPK() {
    }

    public short getKey() {
        return this.key;
    }

    public String toString() {
        return Short.toString(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ShortFieldPK other = (ShortFieldPK)obj;
        return this.key == other.key;
    }

    public int compareTo(Object o) {
        if (o instanceof ShortFieldPK) {
            ShortFieldPK other = (ShortFieldPK)o;
            return this.key - other.key;
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    protected Object createKeyAsObject() {
        return this.key;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(this.key);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readShort();
    }
}

