/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFileRecordReader;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class RCFileCat
implements Tool {
    Configuration conf = null;
    private static String TAB = "\t";
    private static String NEWLINE = "\r\n";
    private static String Usage = "RCFileCat [--start=start_offet] [--length=len] fileName";

    public int run(String[] args) throws Exception {
        long start = 0L;
        long length = -1L;
        if (args.length < 1 || args.length > 3) {
            RCFileCat.printUsage(null);
        }
        Path fileName = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--start=")) {
                start = Long.parseLong(arg.substring("--start=".length()));
                continue;
            }
            if (arg.startsWith("--length=")) {
                length = Long.parseLong(arg.substring("--length=".length()));
                continue;
            }
            if (fileName == null) {
                fileName = new Path(arg);
                continue;
            }
            RCFileCat.printUsage(null);
        }
        FileSystem fs = FileSystem.get((URI)fileName.toUri(), (Configuration)this.conf);
        long fileLen = fs.getFileStatus(fileName).getLen();
        if (start < 0L) {
            start = 0L;
        }
        if (start > fileLen) {
            return 0;
        }
        if (length < 0L || start + length > fileLen) {
            length = fileLen - start;
        }
        FileSplit split = new FileSplit(fileName, start, length, new JobConf(this.conf));
        RCFileRecordReader recordReader = new RCFileRecordReader(this.conf, split);
        LongWritable key = new LongWritable();
        BytesRefArrayWritable value = new BytesRefArrayWritable();
        Text txt = new Text();
        while (recordReader.next(key, value)) {
            txt.clear();
            for (int i = 0; i < value.size(); ++i) {
                BytesRefWritable v = value.get(i);
                txt.set(v.getData(), v.getStart(), v.getLength());
                System.out.print(txt.toString());
                if (i >= value.size() - 1) continue;
                System.out.print(TAB);
            }
            System.out.print(NEWLINE);
        }
        return 0;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public static void main(String[] args) {
        try {
            Configuration conf = new Configuration();
            RCFileCat instance = new RCFileCat();
            instance.setConf(conf);
            ToolRunner.run((Tool)instance, (String[])args);
        }
        catch (Exception e) {
            RCFileCat.printUsage(e.getMessage());
        }
    }

    private static void printUsage(String errorMsg) {
        System.out.println(Usage);
        if (errorMsg != null) {
            System.out.println(errorMsg);
        }
        System.exit(1);
    }
}

