/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.udaf.example;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="example_max", value="_FUNC_(expr) - Returns the maximum value of expr")
public class UDAFExampleMax
extends UDAF {

    public static class MaxStringEvaluator
    implements UDAFEvaluator {
        private Text mMax;
        private boolean mEmpty;

        public MaxStringEvaluator() {
            this.init();
        }

        public void init() {
            this.mMax = null;
            this.mEmpty = true;
        }

        public boolean iterate(Text o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMax = new Text(o);
                    this.mEmpty = false;
                } else if (ShimLoader.getHadoopShims().compareText(this.mMax, o) < 0) {
                    this.mMax.set(o);
                }
            }
            return true;
        }

        public Text terminatePartial() {
            return this.mEmpty ? null : this.mMax;
        }

        public boolean merge(Text o) {
            return this.iterate(o);
        }

        public Text terminate() {
            return this.mEmpty ? null : this.mMax;
        }
    }

    public static class MaxDoubleEvaluator
    implements UDAFEvaluator {
        private double mMax;
        private boolean mEmpty;

        public MaxDoubleEvaluator() {
            this.init();
        }

        public void init() {
            this.mMax = 0.0;
            this.mEmpty = true;
        }

        public boolean iterate(DoubleWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMax = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMax = Math.max(this.mMax, o.get());
                }
            }
            return true;
        }

        public DoubleWritable terminatePartial() {
            return this.mEmpty ? null : new DoubleWritable(this.mMax);
        }

        public boolean merge(DoubleWritable o) {
            return this.iterate(o);
        }

        public DoubleWritable terminate() {
            return this.mEmpty ? null : new DoubleWritable(this.mMax);
        }
    }

    public static class MaxFloatEvaluator
    implements UDAFEvaluator {
        private float mMax;
        private boolean mEmpty;

        public MaxFloatEvaluator() {
            this.init();
        }

        public void init() {
            this.mMax = 0.0f;
            this.mEmpty = true;
        }

        public boolean iterate(FloatWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMax = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMax = Math.max(this.mMax, o.get());
                }
            }
            return true;
        }

        public FloatWritable terminatePartial() {
            return this.mEmpty ? null : new FloatWritable(this.mMax);
        }

        public boolean merge(FloatWritable o) {
            return this.iterate(o);
        }

        public FloatWritable terminate() {
            return this.mEmpty ? null : new FloatWritable(this.mMax);
        }
    }

    public static class MaxLongEvaluator
    implements UDAFEvaluator {
        private long mMax;
        private boolean mEmpty;

        public MaxLongEvaluator() {
            this.init();
        }

        public void init() {
            this.mMax = 0L;
            this.mEmpty = true;
        }

        public boolean iterate(LongWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMax = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMax = Math.max(this.mMax, o.get());
                }
            }
            return true;
        }

        public LongWritable terminatePartial() {
            return this.mEmpty ? null : new LongWritable(this.mMax);
        }

        public boolean merge(LongWritable o) {
            return this.iterate(o);
        }

        public LongWritable terminate() {
            return this.mEmpty ? null : new LongWritable(this.mMax);
        }
    }

    public static class MaxIntEvaluator
    implements UDAFEvaluator {
        private int mMax;
        private boolean mEmpty;

        public MaxIntEvaluator() {
            this.init();
        }

        public void init() {
            this.mMax = 0;
            this.mEmpty = true;
        }

        public boolean iterate(IntWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMax = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMax = Math.max(this.mMax, o.get());
                }
            }
            return true;
        }

        public IntWritable terminatePartial() {
            return this.mEmpty ? null : new IntWritable(this.mMax);
        }

        public boolean merge(IntWritable o) {
            return this.iterate(o);
        }

        public IntWritable terminate() {
            return this.mEmpty ? null : new IntWritable(this.mMax);
        }
    }

    public static class MaxShortEvaluator
    implements UDAFEvaluator {
        private short mMax;
        private boolean mEmpty;

        public MaxShortEvaluator() {
            this.init();
        }

        public void init() {
            this.mMax = 0;
            this.mEmpty = true;
        }

        public boolean iterate(ShortWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMax = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMax = (short)Math.max(this.mMax, o.get());
                }
            }
            return true;
        }

        public ShortWritable terminatePartial() {
            return this.mEmpty ? null : new ShortWritable(this.mMax);
        }

        public boolean merge(ShortWritable o) {
            return this.iterate(o);
        }

        public ShortWritable terminate() {
            return this.mEmpty ? null : new ShortWritable(this.mMax);
        }
    }
}

