/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.sql.SQLException;
import org.apache.hadoop.hive.jdbc.HiveResultSetMetaData;

public class JdbcColumn {
    private final String columnName;
    private final String tableName;
    private final String tableCatalog;
    private final String type;
    private final String comment;
    private final int ordinalPos;

    JdbcColumn(String columnName, String tableName, String tableCatalog, String type, String comment, int ordinalPos) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.tableCatalog = tableCatalog;
        this.type = type;
        this.comment = comment;
        this.ordinalPos = ordinalPos;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getType() {
        return this.type;
    }

    public Integer getSqlType() throws SQLException {
        return HiveResultSetMetaData.hiveTypeToSqlType(this.type);
    }

    public Integer getColumnSize() {
        if (this.type.equalsIgnoreCase("string")) {
            return Integer.MAX_VALUE;
        }
        if (this.type.equalsIgnoreCase("tinyint")) {
            return 3;
        }
        if (this.type.equalsIgnoreCase("smallint")) {
            return 5;
        }
        if (this.type.equalsIgnoreCase("int")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("bigint")) {
            return 19;
        }
        if (this.type.equalsIgnoreCase("float")) {
            return 12;
        }
        if (this.type.equalsIgnoreCase("double")) {
            return 22;
        }
        return null;
    }

    public Integer getNumPrecRadix() {
        if (this.type.equalsIgnoreCase("tinyint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("smallint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("int")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("bigint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("float")) {
            return 2;
        }
        if (this.type.equalsIgnoreCase("double")) {
            return 2;
        }
        return null;
    }

    public Integer getDecimalDigits() {
        if (this.type.equalsIgnoreCase("tinyint")) {
            return 0;
        }
        if (this.type.equalsIgnoreCase("smallint")) {
            return 0;
        }
        if (this.type.equalsIgnoreCase("int")) {
            return 0;
        }
        if (this.type.equalsIgnoreCase("bigint")) {
            return 0;
        }
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public int getOrdinalPos() {
        return this.ordinalPos;
    }
}

