/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.javaoptions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.aspectj.ajde.ui.javaoptions.JavaBuildOptions;
import org.aspectj.ajde.ui.swing.OptionsPanel;

public class JavaDebugOptionsPanel
extends OptionsPanel {
    private final String[] debugOptions = new String[]{"generate", "do not generate"};
    private final String[] preserveOptions = new String[]{"preserve", "optimize out"};
    private static final long serialVersionUID = 4491319302490183151L;
    private JPanel parentPanel;
    private Border debugEtchedBorder;
    private TitledBorder debugTitleBorder;
    private Border debugCompoundBorder;
    private JPanel debugPanel;
    private Box debugBox = Box.createVerticalBox();
    private JavaBuildOptions javaBuildOptions;
    private Map debugComboBoxes = new HashMap();

    public JavaDebugOptionsPanel(JavaBuildOptions javaBuildOptions) {
        this.javaBuildOptions = javaBuildOptions;
        try {
            this.jbInit();
            this.setName("Java Debug Options");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadOptions() throws IOException {
        this.createDebugContents();
    }

    public void saveOptions() throws IOException {
        Set s = this.debugComboBoxes.entrySet();
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String javaOption = (String)entry.getKey();
            JComboBox combo = (JComboBox)entry.getValue();
            String value = (String)combo.getSelectedItem();
            this.javaBuildOptions.setOption(javaOption, value);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.createBorders();
        this.addBordersToPanel();
        this.add((Component)this.parentPanel, "North");
    }

    private void createDebugContents() {
        this.createDebugEntry("Add line number attributes to generated class files", "org.eclipse.jdt.core.compiler.debug.localVariable");
        this.createDebugEntry("Add source file name to generated class file", "org.eclipse.jdt.core.compiler.debug.sourceFile");
        this.createDebugEntry("Add variable attributes to generated class files", "org.eclipse.jdt.core.compiler.debug.lineNumber");
        this.createDebugEntry("Preserve unused (never read) local variables", "org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        this.debugPanel.add(this.debugBox);
    }

    private void createDebugEntry(String labelText, String javaOptionToSet) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setFont(new Font("Dialog", 0, 11));
        label.setText(labelText);
        panel.add((Component)label, "West");
        JComboBox<String> debug = null;
        if (javaOptionToSet.equals("org.eclipse.jdt.core.compiler.codegen.unusedLocal")) {
            debug = new JComboBox<String>(this.preserveOptions);
            String value = (String)this.javaBuildOptions.getJavaBuildOptionsMap().get(javaOptionToSet);
            if (value.equals("preserve")) {
                debug.setSelectedIndex(0);
            } else {
                debug.setSelectedIndex(1);
            }
        } else {
            debug = new JComboBox<String>(this.debugOptions);
            String value = (String)this.javaBuildOptions.getJavaBuildOptionsMap().get(javaOptionToSet);
            if (value.equals("generate")) {
                debug.setSelectedIndex(0);
            } else {
                debug.setSelectedIndex(1);
            }
        }
        panel.add(debug, "East");
        this.debugBox.add((Component)panel, null);
        this.debugComboBoxes.put(javaOptionToSet, debug);
    }

    private void createBorders() {
        this.debugEtchedBorder = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.debugTitleBorder = new TitledBorder(this.debugEtchedBorder, "Debug Options");
        this.debugCompoundBorder = BorderFactory.createCompoundBorder(this.debugTitleBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.debugTitleBorder.setTitleFont(new Font("Dialog", 0, 11));
    }

    private void addBordersToPanel() {
        this.parentPanel = new JPanel();
        this.parentPanel.setLayout(new BorderLayout());
        this.debugPanel = new JPanel();
        this.debugPanel.setBorder(this.debugCompoundBorder);
        this.parentPanel.add((Component)this.debugPanel, "Center");
    }
}

