/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.ElementValueGen;

public class ArrayElementValueGen
extends ElementValueGen {
    private static final ElementValueGen[] NO_VALUES = new ElementValueGen[0];
    private ElementValueGen[] evalues = NO_VALUES;

    public ElementValueGen[] getElementValuesArray() {
        return this.evalues;
    }

    public int getElementValuesArraySize() {
        return this.evalues.length;
    }

    public ArrayElementValueGen(ConstantPool cp) {
        super(91, cp);
    }

    public ArrayElementValueGen(int type, ElementValueGen[] datums, ConstantPool cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor");
        }
        this.evalues = datums;
    }

    public ElementValueGen getElementValue() {
        ElementValueGen[] immutableData = new ElementValueGen[this.evalues.length];
        int i = 0;
        while (i < this.evalues.length) {
            immutableData[i] = this.evalues[i];
            ++i;
        }
        return new ArrayElementValueGen(this.type, immutableData, this.cpGen);
    }

    public ArrayElementValueGen(ArrayElementValueGen value, ConstantPool cpool, boolean copyPoolEntries) {
        super(91, cpool);
        this.evalues = new ElementValueGen[value.getElementValuesArraySize()];
        ElementValueGen[] in = value.getElementValuesArray();
        int i = 0;
        while (i < in.length) {
            this.evalues[i] = ElementValueGen.copy(in[i], cpool, copyPoolEntries);
            ++i;
        }
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.evalues.length);
        int i = 0;
        while (i < this.evalues.length) {
            this.evalues[i].dump(dos);
            ++i;
        }
    }

    public String stringifyValue() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < this.evalues.length) {
            ElementValueGen element = this.evalues[i];
            sb.append(element.stringifyValue());
            if (i + 1 < this.evalues.length) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public void addElement(ElementValueGen gen) {
        ElementValueGen[] old = this.evalues;
        this.evalues = new ElementValueGen[this.evalues.length + 1];
        System.arraycopy(old, 0, this.evalues, 0, old.length);
        this.evalues[old.length] = gen;
    }
}

