/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class RuntimeEnhancer {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    private Constructor classEnhancerConstructor;
    private String api;
    private String enhancerName = "ASM";
    private ClassLoaderResolver clr;
    private PluginManager pluginMgr;
    private OMFContext omfContext;
    private boolean initialized = false;
    private static Class[] CLASS_ENHANCER_CONSTRUCTOR_ARGS_TYPES = new Class[]{ClassMetaData.class, ClassLoaderResolver.class, MetaDataManager.class, byte[].class};

    public RuntimeEnhancer(PersistenceConfiguration config) {
        this.omfContext = new OMFContext(config, 2);
        this.api = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.persistenceApiName");
        this.pluginMgr = this.omfContext.getPluginManager();
        this.clr = this.omfContext.getClassLoaderResolver(null);
    }

    public RuntimeEnhancer() {
        this(new PersistenceConfiguration(){});
    }

    public byte[] enhance(String className, byte[] classdefinition, ClassLoader loader) {
        if (!this.initialized) {
            this.initialize();
        }
        this.clr.setPrimary((ClassLoader)new EnhancerClassLoader(loader));
        try {
            Class clazz = null;
            try {
                clazz = this.clr.classForName(className);
            }
            catch (ClassNotResolvedException e1) {
                DataNucleusEnhancer.LOGGER.debug((Object)StringUtils.getStringFromStackTrace((Throwable)e1));
                return null;
            }
            AbstractClassMetaData acmd = this.omfContext.getMetaDataManager().getMetaDataForClass(clazz, this.clr);
            if (acmd == null) {
                DataNucleusEnhancer.LOGGER.debug((Object)("Class " + className + " cannot be enhanced because no metadata has been found."));
                return null;
            }
            ClassEnhancer classEnhancer = null;
            try {
                classEnhancer = (ClassEnhancer)this.classEnhancerConstructor.newInstance(acmd, this.clr, this.omfContext.getMetaDataManager(), classdefinition);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ConstructorError", (Object)this.enhancerName, (Object)this.classEnhancerConstructor.getDeclaringClass().getName(), (Object)e.getTargetException());
                DataNucleusEnhancer.LOGGER.error((Object)msg, (Throwable)e);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ConstructorError", (Object)this.enhancerName, (Object)this.classEnhancerConstructor.getDeclaringClass().getName(), (Object)e.getMessage());
                DataNucleusEnhancer.LOGGER.error((Object)msg, (Throwable)e);
                return null;
            }
            classEnhancer.enhance();
            return classEnhancer.getClassBytes();
        }
        catch (Throwable ex) {
            DataNucleusEnhancer.LOGGER.error((Object)StringUtils.getStringFromStackTrace((Throwable)ex));
            return null;
        }
    }

    private synchronized void initialize() {
        Class classEnhancerClass;
        if (this.api != null) {
            this.omfContext.setApi(this.api);
        }
        String className = null;
        try {
            className = this.pluginMgr.getAttributeValueForExtension("org.datanucleus.enhancer.enhancer", new String[]{"name", "api"}, new String[]{this.enhancerName, this.api}, "class-name");
            classEnhancerClass = this.clr.classForName(className, RuntimeEnhancer.class.getClassLoader());
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ClassNotFound", (Object)this.enhancerName, className);
            DataNucleusEnhancer.LOGGER.error((Object)msg);
            throw new NucleusException(msg, (Throwable)e);
        }
        catch (Error e2) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ClassNotFound", (Object)this.enhancerName, className);
            DataNucleusEnhancer.LOGGER.error((Object)msg);
            throw new NucleusException(msg, (Throwable)e2);
        }
        try {
            this.classEnhancerConstructor = classEnhancerClass.getConstructor(CLASS_ENHANCER_CONSTRUCTOR_ARGS_TYPES);
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ConstructorNotFound", (Object)this.enhancerName, (Object)classEnhancerClass.getName(), (Object)e.getMessage());
            DataNucleusEnhancer.LOGGER.error((Object)msg, (Throwable)e);
            throw new NucleusException(msg, (Throwable)e);
        }
        catch (Error e2) {
            String msg = LOCALISER.msg("Enhancer.ClassEnhancer.ConstructorNotFound", (Object)this.enhancerName, (Object)classEnhancerClass.getName(), (Object)e2.getMessage());
            DataNucleusEnhancer.LOGGER.error((Object)msg, (Throwable)e2);
            throw new NucleusException(msg, (Throwable)e2);
        }
        this.initialized = true;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setEnhancerName(String enhancerName) {
        this.enhancerName = enhancerName;
    }

    public class EnhancerClassLoader
    extends ClassLoader {
        EnhancerClassLoader(ClassLoader loader) {
            super(loader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz;
            block13: {
                Class<?> c = super.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                if (name.startsWith("java.")) {
                    return super.loadClass(name, resolve);
                }
                if (name.startsWith("javax.")) {
                    return super.loadClass(name, resolve);
                }
                if (name.startsWith("org.datanucleus.jpa.annotations")) {
                    return super.loadClass(name, resolve);
                }
                String resource = StringUtils.replaceAll((String)name, (String)".", (String)"/") + ".class";
                URL url = super.getResource(resource);
                if (url == null) {
                    throw new ClassNotFoundException(name);
                }
                InputStream is = url.openStream();
                try {
                    int count;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] b = new byte[2048];
                    while ((count = is.read(b, 0, 2048)) != -1) {
                        os.write(b, 0, count);
                    }
                    byte[] bytes = os.toByteArray();
                    clazz = this.defineClass(name, bytes, 0, bytes.length);
                    if (is == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                    catch (SecurityException e) {
                        return super.loadClass(name, resolve);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                }
                is.close();
            }
            return clazz;
        }
    }
}

